/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.account;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.client.rest.manager.PostEntity;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.AbstractRequestFilterBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;

public class MessageCutoffRequestBuilder
extends AbstractRequestFilterBuilder<String, MessageCutoffRequestBuilder>
implements IEXCloudV1RestRequest<String> {
    private Long totalMessages;

    public MessageCutoffRequestBuilder withTotalMessages(Long totalMessages) {
        this.totalMessages = totalMessages;
        return this;
    }

    @Override
    public RestRequest<String> build() {
        return RestRequestBuilder.builder().withPath("/account/circuitbreaker").post().withRequest(new MessageCutoffPostEntity(this.totalMessages)).withResponse(new GenericType<String>(){}).withSecretToken().addQueryParam(this.getFilterParams()).build();
    }

    static class MessageCutoffPostEntity
    extends PostEntity {
        private static final long serialVersionUID = -1499748924717100344L;
        private final Long totalMessages;

        public MessageCutoffPostEntity(Long totalMessages) {
            this.totalMessages = totalMessages;
        }

        public Long getTotalMessages() {
            return this.totalMessages;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MessageCutoffPostEntity that = (MessageCutoffPostEntity)o;
            return Objects.equal((Object)this.totalMessages, (Object)that.totalMessages);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.totalMessages});
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("totalMessages", (Object)this.totalMessages).toString();
        }
    }
}

