/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.alternative;

import java.util.List;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.alternative.Sentiment;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.alternative.AbstractSentimentRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.alternative.SentimentType;
import pl.zankowski.iextrading4j.client.rest.request.util.RequestUtil;

public class SentimentRequestBuilder
extends AbstractSentimentRequestBuilder<List<Sentiment>, SentimentRequestBuilder>
implements IEXCloudV1RestRequest<List<Sentiment>> {
    public SentimentRequestBuilder withSentimentType(SentimentType sentimentType) {
        this.sentimentType = sentimentType;
        return this;
    }

    @Override
    public RestRequest<List<Sentiment>> build() {
        if (this.date != null) {
            return this.requestWithDate();
        }
        if (this.sentimentType != null) {
            return this.requestWithType();
        }
        return this.request();
    }

    private RestRequest<List<Sentiment>> request() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/sentiment").addPathParam("symbol", this.getSymbol()).get().withResponse(new GenericType<List<Sentiment>>(){}).build();
    }

    private RestRequest<List<Sentiment>> requestWithType() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/sentiment/{type}").addPathParam("symbol", this.getSymbol()).addPathParam("type", this.sentimentType.name().toLowerCase()).get().withResponse(new GenericType<List<Sentiment>>(){}).build();
    }

    private RestRequest<List<Sentiment>> requestWithDate() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/sentiment/{type}/{date}").addPathParam("symbol", this.getSymbol()).addPathParam("type", this.sentimentType.name().toLowerCase()).addPathParam("date", RequestUtil.IEX_DATE_FORMATTER.format(this.date)).get().withResponse(new GenericType<List<Sentiment>>(){}).build();
    }
}

