/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.datapoint;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.IRestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.datapoint.TimeSeriesRange;
import pl.zankowski.iextrading4j.client.rest.request.datapoint.TimeSeriesRangeUnit;

public class AbstractTimeSeriesRequestBuilder<R, B extends IRestRequestBuilder<R>>
implements IEXCloudV1RestRequest<R> {
    public static final DateTimeFormatter IEX_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String RANGE_PARAM_NAME = "range";
    private static final String CALENDAR_PARAM_NAME = "calendar";
    private static final String LIMIT_PARAM_NAME = "limit";
    private static final String FROM_PARAM_NAME = "from";
    private static final String TO_PARAM_NAME = "to";
    private static final String ON_PARAM_NAME = "on";
    private static final String LAST_PARAM_NAME = "last";
    private static final String FIRST_PARAM_NAME = "first";
    private static final String UPDATED_PARAM_NAME = "updated";
    private static final String SUBATTRIBUTE_PARAM_NAME = "subattribute";
    private static final String DATE_FIELD_PARAM_NAME = "dateField";
    private final Map<String, String> queryParameters = Maps.newHashMap();
    private final String id;
    private final GenericType<R> responseType;
    private String key;
    private String subKey;

    protected AbstractTimeSeriesRequestBuilder(String id, GenericType<R> responseType) {
        this.id = id;
        this.responseType = responseType;
    }

    public B withFrom(LocalDate from) {
        this.queryParameters.put(FROM_PARAM_NAME, IEX_DATE_FORMATTER.format(from));
        return (B)this;
    }

    public B withTo(LocalDate to) {
        this.queryParameters.put(TO_PARAM_NAME, IEX_DATE_FORMATTER.format(to));
        return (B)this;
    }

    protected B withOn(LocalDate on) {
        this.queryParameters.put(ON_PARAM_NAME, IEX_DATE_FORMATTER.format(on));
        return (B)this;
    }

    public B withLast(int last) {
        this.queryParameters.put(LAST_PARAM_NAME, String.valueOf(last));
        return (B)this;
    }

    public B withFirst(int first) {
        this.queryParameters.put(FIRST_PARAM_NAME, String.valueOf(first));
        return (B)this;
    }

    public B withRange(TimeSeriesRange range) {
        this.queryParameters.put(RANGE_PARAM_NAME, range.getCode());
        return (B)this;
    }

    public B withRange(int number, TimeSeriesRangeUnit unit) {
        this.queryParameters.put(RANGE_PARAM_NAME, number + unit.getCode());
        return (B)this;
    }

    public B withCalendar(boolean state) {
        this.queryParameters.put(CALENDAR_PARAM_NAME, String.valueOf(state));
        return (B)this;
    }

    protected B withLimit(int limit) {
        this.queryParameters.put(LIMIT_PARAM_NAME, String.valueOf(limit));
        return (B)this;
    }

    protected B withUpdated(boolean state) {
        this.queryParameters.put(UPDATED_PARAM_NAME, String.valueOf(state));
        return (B)this;
    }

    protected B withSubattribute(String subattribute) {
        this.queryParameters.put(SUBATTRIBUTE_PARAM_NAME, subattribute);
        return (B)this;
    }

    protected B withSubattribute(String keyName, String value) {
        this.queryParameters.put(SUBATTRIBUTE_PARAM_NAME, keyName + "|" + value);
        return (B)this;
    }

    protected B withDateField(String dateField) {
        this.queryParameters.put(DATE_FIELD_PARAM_NAME, dateField);
        return (B)this;
    }

    protected B withKey(String key) {
        this.key = key;
        return (B)this;
    }

    protected B withSubKey(String subKey) {
        this.subKey = subKey;
        return (B)this;
    }

    @Override
    public RestRequest<R> build() {
        if (this.subKey != null) {
            return RestRequestBuilder.builder().withPath("/time-series/{id}/{key}/{subKey}").addPathParam("id", this.id).addPathParam("key", this.key).addPathParam("subKey", this.subKey).get().withResponse(this.responseType).addQueryParam(this.queryParameters).build();
        }
        if (this.key != null) {
            return RestRequestBuilder.builder().withPath("/time-series/{id}/{key}").addPathParam("id", this.id).addPathParam("key", this.key).get().withResponse(this.responseType).addQueryParam(this.queryParameters).build();
        }
        return RestRequestBuilder.builder().withPath("/time-series/{id}").addPathParam("id", this.id).get().withResponse(this.responseType).addQueryParam(this.queryParameters).build();
    }
}

