/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.datapoint;

import java.util.List;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.datapoint.DataPoint;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.stocks.AbstractStocksRequestBuilder;

public class DataPointsRequestBuilder
extends AbstractStocksRequestBuilder<List<DataPoint>, DataPointsRequestBuilder>
implements IEXCloudV1RestRequest<List<DataPoint>> {
    public KeyDataPointRequestBuilder withKey(String key) {
        return new KeyDataPointRequestBuilder(this.getSymbol(), key);
    }

    @Override
    public RestRequest<List<DataPoint>> build() {
        return RestRequestBuilder.builder().withPath("/data-points/{symbol}").addPathParam("symbol", this.getSymbol()).get().withResponse(new GenericType<List<DataPoint>>(){}).build();
    }

    public static class KeyDataPointRequestBuilder
    implements IEXCloudV1RestRequest<String> {
        private final String symbol;
        private final String key;

        public KeyDataPointRequestBuilder(String symbol, String key) {
            this.symbol = symbol;
            this.key = key;
        }

        @Override
        public RestRequest<String> build() {
            return RestRequestBuilder.builder().withPath("/data-points/{symbol}/{key}").addPathParam("symbol", this.symbol).addPathParam("key", this.key).get().withResponse(String.class).build();
        }
    }
}

