/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.marketdata;

import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.marketdata.HIST;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.AbstractRequestFilterBuilder;
import pl.zankowski.iextrading4j.client.rest.request.util.RequestUtil;

public class HistRequestBuilder
extends AbstractRequestFilterBuilder<Map<String, List<HIST>>, HistRequestBuilder> {
    public ParameterizedHistRequestBuilder withDate(LocalDate date) {
        return new ParameterizedHistRequestBuilder(date);
    }

    @Override
    public RestRequest<Map<String, List<HIST>>> build() {
        return RestRequestBuilder.builder().withPath("/hist").get().withResponse(new GenericType<Map<String, List<HIST>>>(){}).addQueryParam(this.getFilterParams()).build();
    }

    public static class ParameterizedHistRequestBuilder
    extends AbstractRequestFilterBuilder<List<HIST>, HistRequestBuilder> {
        private LocalDate date;

        ParameterizedHistRequestBuilder(LocalDate date) {
            this.date = Objects.requireNonNull(date);
        }

        private Map<String, String> getDateParams() {
            return ImmutableMap.builder().put((Object)"date", (Object)RequestUtil.IEX_DATE_FORMATTER.format(this.date)).build();
        }

        @Override
        public RestRequest<List<HIST>> build() {
            return RestRequestBuilder.builder().withPath("/hist").get().withResponse(new GenericType<List<HIST>>(){}).addQueryParam(this.getDateParams()).addQueryParam(this.getFilterParams()).build();
        }
    }
}

