/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.options;

import java.util.List;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.options.Option;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.options.OptionSide;
import pl.zankowski.iextrading4j.client.rest.request.stocks.AbstractStocksRequestBuilder;

public class OptionsRequestBuilder
extends AbstractStocksRequestBuilder<List<String>, OptionsRequestBuilder>
implements IEXCloudV1RestRequest<List<String>> {
    public SpecificOptionRequestBuilder withExpirationDate(String expirationDate) {
        return new SpecificOptionRequestBuilder(expirationDate, this.getSymbol());
    }

    @Override
    public RestRequest<List<String>> build() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/options").addPathParam("symbol", this.getSymbol()).get().withResponse(new GenericType<List<String>>(){}).build();
    }

    public static class SpecificOptionRequestBuilder
    extends AbstractStocksRequestBuilder<List<Option>, SpecificOptionRequestBuilder>
    implements IEXCloudV1RestRequest<List<Option>> {
        private String expirationDate;
        private OptionSide side;

        public SpecificOptionRequestBuilder(String expirationDate, String symbol) {
            this.expirationDate = expirationDate;
            this.withSymbol(symbol);
        }

        public SpecificOptionRequestBuilder withSide(OptionSide side) {
            this.side = side;
            return this;
        }

        private RestRequest<List<Option>> request() {
            return RestRequestBuilder.builder().withPath("/stock/{symbol}/options/{expirationDate}").addPathParam("symbol", this.getSymbol()).addPathParam("expirationDate", this.expirationDate).get().withResponse(new GenericType<List<Option>>(){}).build();
        }

        private RestRequest<List<Option>> requestWithSide() {
            return RestRequestBuilder.builder().withPath("/stock/{symbol}/options/{expirationDate}/{side}").addPathParam("symbol", this.getSymbol()).addPathParam("expirationDate", this.expirationDate).addPathParam("side", this.side.getName()).get().withResponse(new GenericType<List<Option>>(){}).build();
        }

        @Override
        public RestRequest<List<Option>> build() {
            if (this.side != null) {
                return this.requestWithSide();
            }
            return this.request();
        }
    }
}

