/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.refdata.v1;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.refdata.v1.SymbolMapping;
import pl.zankowski.iextrading4j.api.util.ListUtil;
import pl.zankowski.iextrading4j.client.rest.manager.PostEntity;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.AbstractRequestFilterBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;

public class IsinMapperRequestBuilder
extends AbstractRequestFilterBuilder<List<List<SymbolMapping>>, IsinMapperRequestBuilder>
implements IEXCloudV1RestRequest<List<List<SymbolMapping>>> {
    private final List<String> isinList = Lists.newArrayList();

    public IsinMapperRequestBuilder addIsin(String isin) {
        this.isinList.add(isin);
        return this;
    }

    @Override
    public RestRequest<List<List<SymbolMapping>>> build() {
        return RestRequestBuilder.builder().withPath("/ref-data/isin").post().withRequest(new IsinPostEntity(this.isinList)).withResponse(new GenericType<List<List<SymbolMapping>>>(){}).addQueryParam(this.getFilterParams()).build();
    }

    static class IsinPostEntity
    extends PostEntity {
        private static final long serialVersionUID = -3553375472577931811L;
        private final List<String> isin;

        public IsinPostEntity(List<String> isin) {
            this.isin = ListUtil.immutableList(isin);
        }

        public List<String> getIsin() {
            return this.isin;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IsinPostEntity that = (IsinPostEntity)o;
            return Objects.equal(this.isin, that.isin);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.isin});
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("isin", this.isin).toString();
        }
    }
}

