/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.refdata.v1;

import java.time.LocalDate;
import java.util.List;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.refdata.v1.HolidayAndTradingDate;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.AbstractRequestFilterBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.refdata.v1.DateDirection;
import pl.zankowski.iextrading4j.client.rest.request.refdata.v1.DateType;
import pl.zankowski.iextrading4j.client.rest.request.util.RequestUtil;

public class UsHolidayAndTradingDateRequestBuilder
extends AbstractRequestFilterBuilder<List<HolidayAndTradingDate>, UsHolidayAndTradingDateRequestBuilder>
implements IEXCloudV1RestRequest<List<HolidayAndTradingDate>> {
    private static final String DIRECTION_PARAM = "direction";
    private static final String TYPE_PARAM = "type";
    private DateType type;
    private DateDirection direction;
    private Integer last;
    private LocalDate startDate;

    public UsHolidayAndTradingDateRequestBuilder withType(DateType type) {
        this.type = type;
        return this;
    }

    public UsHolidayAndTradingDateRequestBuilder withDirection(DateDirection direction) {
        this.direction = direction;
        return this;
    }

    public UsHolidayAndTradingDateRequestBuilder withLast(Integer last) {
        this.last = last;
        return this;
    }

    public UsHolidayAndTradingDateRequestBuilder withStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    private RestRequest<List<HolidayAndTradingDate>> request() {
        return RestRequestBuilder.builder().withPath("/ref-data/us/dates/{type}/{direction}").addPathParam(TYPE_PARAM, this.type.name().toLowerCase()).addPathParam(DIRECTION_PARAM, this.direction.name().toLowerCase()).get().withResponse(new GenericType<List<HolidayAndTradingDate>>(){}).addQueryParam(this.getFilterParams()).build();
    }

    private RestRequest<List<HolidayAndTradingDate>> requestWithLast() {
        return RestRequestBuilder.builder().withPath("/ref-data/us/dates/{type}/{direction}/{last}").addPathParam(TYPE_PARAM, this.type.name().toLowerCase()).addPathParam(DIRECTION_PARAM, this.direction.name().toLowerCase()).addPathParam("last", String.valueOf(this.last)).get().withResponse(new GenericType<List<HolidayAndTradingDate>>(){}).addQueryParam(this.getFilterParams()).build();
    }

    private RestRequest<List<HolidayAndTradingDate>> requestWithLastAndDirection() {
        return RestRequestBuilder.builder().withPath("/ref-data/us/dates/{type}/{direction}/{last}/{startDate}").addPathParam(TYPE_PARAM, this.type.name().toLowerCase()).addPathParam(DIRECTION_PARAM, this.direction.name().toLowerCase()).addPathParam("last", String.valueOf(this.last)).addPathParam("startDate", RequestUtil.IEX_DATE_FORMATTER.format(this.startDate)).get().withResponse(new GenericType<List<HolidayAndTradingDate>>(){}).addQueryParam(this.getFilterParams()).build();
    }

    @Override
    public RestRequest<List<HolidayAndTradingDate>> build() {
        if (this.startDate != null) {
            return this.requestWithLastAndDirection();
        }
        if (this.last != null) {
            return this.requestWithLast();
        }
        return this.request();
    }
}

