/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stats;

import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.stats.HistoricalDailyStats;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.AbstractRequestFilterBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXApiRestRequest;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.util.RequestUtil;

public class HistoricalDailyStatsRequestBuilder
extends AbstractRequestFilterBuilder<List<HistoricalDailyStats>, HistoricalDailyStatsRequestBuilder>
implements IEXApiRestRequest<List<HistoricalDailyStats>>,
IEXCloudV1RestRequest<List<HistoricalDailyStats>> {
    private Integer last;
    private YearMonth date;
    private LocalDate fullDate;

    public HistoricalDailyStatsRequestBuilder withDate(YearMonth date) {
        this.date = date;
        return this;
    }

    public HistoricalDailyStatsRequestBuilder withDate(LocalDate date) {
        this.fullDate = date;
        return this;
    }

    public HistoricalDailyStatsRequestBuilder withLast(Integer last) {
        this.last = last;
        return this;
    }

    private Map<String, String> getDateParams() {
        if (this.date != null) {
            return ImmutableMap.builder().put((Object)"date", (Object)RequestUtil.IEX_YEAR_MONTH_FORMATTER.format(this.date)).build();
        }
        if (this.fullDate != null) {
            return ImmutableMap.builder().put((Object)"date", (Object)RequestUtil.IEX_DATE_FORMATTER.format(this.fullDate)).build();
        }
        if (this.last != null) {
            return ImmutableMap.builder().put((Object)"last", (Object)String.valueOf(this.last)).build();
        }
        return ImmutableMap.of();
    }

    @Override
    public RestRequest<List<HistoricalDailyStats>> build() {
        return RestRequestBuilder.builder().withPath("/stats/historical/daily").get().withResponse(new GenericType<List<HistoricalDailyStats>>(){}).addQueryParam(this.getDateParams()).addQueryParam(this.getFilterParams()).build();
    }
}

