/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stats;

import com.google.common.collect.ImmutableMap;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.stats.HistoricalStats;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.AbstractRequestFilterBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXApiRestRequest;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.util.RequestUtil;

public class HistoricalStatsRequestBuilder
extends AbstractRequestFilterBuilder<List<HistoricalStats>, HistoricalStatsRequestBuilder>
implements IEXApiRestRequest<List<HistoricalStats>>,
IEXCloudV1RestRequest<List<HistoricalStats>> {
    private YearMonth date;

    public HistoricalStatsRequestBuilder withDate(YearMonth date) {
        this.date = date;
        return this;
    }

    private Map<String, String> getDateParams() {
        if (this.date != null) {
            return ImmutableMap.builder().put((Object)"date", (Object)RequestUtil.IEX_YEAR_MONTH_FORMATTER.format(this.date)).build();
        }
        return ImmutableMap.of();
    }

    @Override
    public RestRequest<List<HistoricalStats>> build() {
        return RestRequestBuilder.builder().withPath("/stats/historical").get().withResponse(new GenericType<List<HistoricalStats>>(){}).addQueryParam(this.getDateParams()).addQueryParam(this.getFilterParams()).build();
    }
}

