/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stocks;

import java.time.LocalDate;
import java.util.List;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.stocks.Chart;
import pl.zankowski.iextrading4j.api.stocks.ChartRange;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.stocks.AbstractChartRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.util.RequestUtil;

public class ChartRequestBuilder
extends AbstractChartRequestBuilder<List<Chart>, ChartRequestBuilder>
implements IEXCloudV1RestRequest<List<Chart>> {
    private LocalDate date;
    private ChartRange chartRange;

    public LocalDate getDate() {
        return this.date;
    }

    public ChartRequestBuilder withDate(LocalDate date) {
        this.date = date;
        return this;
    }

    public ChartRange getChartRange() {
        return this.chartRange;
    }

    public ChartRequestBuilder withChartRange(ChartRange chartRange) {
        this.chartRange = chartRange;
        return this;
    }

    @Override
    public RestRequest<List<Chart>> build() {
        if (this.chartRange != null) {
            return this.requestWithRange();
        }
        if (this.date != null) {
            return this.requestWithDate();
        }
        return this.request();
    }

    private RestRequest<List<Chart>> request() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/chart").addPathParam("symbol", this.getSymbol()).get().withResponse(new GenericType<List<Chart>>(){}).addQueryParam(this.getQueryParameters()).build();
    }

    private RestRequest<List<Chart>> requestWithRange() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/chart/{range}").addPathParam("symbol", this.getSymbol()).addPathParam("range", this.getChartRange().getCode()).get().withResponse(new GenericType<List<Chart>>(){}).addQueryParam(this.getQueryParameters()).build();
    }

    private RestRequest<List<Chart>> requestWithDate() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/chart/date/{date}").addPathParam("symbol", this.getSymbol()).addPathParam("date", RequestUtil.IEX_DATE_FORMATTER.format(this.date)).get().withResponse(new GenericType<List<Chart>>(){}).addQueryParam(this.getQueryParameters()).build();
    }
}

