/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stocks;

import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.stocks.Quote;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.stocks.CollectionType;

public class CollectionRequestBuilder
implements IEXCloudV1RestRequest<List<Quote>> {
    private CollectionType collectionType;
    private String collectionName;

    public CollectionRequestBuilder withCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    public CollectionRequestBuilder withCollectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    @Override
    public RestRequest<List<Quote>> build() {
        Objects.requireNonNull(this.collectionType);
        Objects.requireNonNull(this.collectionName);
        return RestRequestBuilder.builder().withPath("/stock/market/collection/{type}").addPathParam("type", this.collectionType.name().toLowerCase()).get().withResponse(new GenericType<List<Quote>>(){}).addQueryParam("collectionName", this.collectionName).build();
    }
}

