/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stocks.v1;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import pl.zankowski.iextrading4j.api.stocks.ChartRange;
import pl.zankowski.iextrading4j.client.rest.request.IRestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.stocks.AbstractChartRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.stocks.v1.BatchStocksType;
import pl.zankowski.iextrading4j.client.rest.request.stocks.v1.Period;

public abstract class AbstractBatchStocksRequestBuilder<R, B extends IRestRequestBuilder<R>>
extends AbstractChartRequestBuilder<R, B> {
    private Set<BatchStocksType> stocksTypes = new HashSet<BatchStocksType>();

    public B withLast(int last) {
        this.queryParameters.put("last", String.valueOf(last));
        return (B)this;
    }

    public B withPeriod(Period period) {
        this.queryParameters.put("period", period.name().toLowerCase());
        return (B)this;
    }

    public B withChartRange(ChartRange chartRange) {
        this.queryParameters.put("range", chartRange.getCode());
        return (B)this;
    }

    public B addType(BatchStocksType stocksType) {
        this.stocksTypes.add(stocksType);
        return (B)this;
    }

    protected void processTypes() {
        this.queryParameters.put("types", this.stocksTypes.stream().map(BatchStocksType::getType).collect(Collectors.joining(",")));
    }
}

