/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stocks.v1;

import com.google.common.collect.Maps;
import java.util.Map;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.IRestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.stocks.AbstractStocksRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.stocks.v1.Period;

public abstract class AbstractLastStocksRequestBuilder<R, B extends IRestRequestBuilder<R>>
extends AbstractStocksRequestBuilder<R, B> {
    protected Integer last;
    protected final Map<String, String> queryParameters = Maps.newHashMap();

    public B withPeriod(Period period) {
        this.queryParameters.put("period", period.name().toLowerCase());
        return (B)this;
    }

    public B withLast(int last) {
        this.last = last;
        return (B)this;
    }

    protected abstract RestRequest<R> request();

    protected abstract RestRequest<R> requestWithLast();

    @Override
    public RestRequest<R> build() {
        if (this.last != null) {
            return this.requestWithLast();
        }
        return this.request();
    }
}

