/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stocks.v1;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.stocks.v1.BatchStocks;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.stocks.v1.AbstractBatchStocksRequestBuilder;

public class BatchMarketStocksRequestBuilder
extends AbstractBatchStocksRequestBuilder<Map<String, BatchStocks>, BatchMarketStocksRequestBuilder> {
    private Set<String> symbols = Sets.newHashSet();

    @Override
    public BatchMarketStocksRequestBuilder withSymbol(String symbol) {
        this.symbols.add(symbol);
        return this;
    }

    public BatchMarketStocksRequestBuilder withSymbols(List<String> symbols) {
        this.symbols.addAll(symbols);
        return this;
    }

    protected void processSymbols() {
        this.queryParameters.put("symbols", this.symbols.stream().collect(Collectors.joining(",")));
    }

    @Override
    public RestRequest<Map<String, BatchStocks>> build() {
        this.processTypes();
        this.processSymbols();
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/batch").addPathParam("symbol", "market").get().withResponse(new GenericType<Map<String, BatchStocks>>(){}).addQueryParam(this.getQueryParameters()).build();
    }
}

