/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.request.stocks.v1;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.stocks.ChartRange;
import pl.zankowski.iextrading4j.api.stocks.v1.TechnicalIndicator;
import pl.zankowski.iextrading4j.api.stocks.v1.TechnicalIndicatorType;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.request.IEXCloudV1RestRequest;
import pl.zankowski.iextrading4j.client.rest.request.stocks.AbstractStocksRequestBuilder;

public class TechnicalIndicatorRequestBuilder
extends AbstractStocksRequestBuilder<TechnicalIndicator, TechnicalIndicatorRequestBuilder>
implements IEXCloudV1RestRequest<TechnicalIndicator> {
    private static final String RANGE_PARAM_NAME = "range";
    private static final String INPUT_1_NAME = "input1";
    private static final String INPUT_2_NAME = "input2";
    private static final String INPUT_3_NAME = "input3";
    private static final String INPUT_4_NAME = "input4";
    private static final String TECHNICAL_INDICATOR_TYPE_NAME = "indicator";
    private final Map<String, String> queryParameters = Maps.newHashMap();
    private TechnicalIndicatorType indicatorType;

    public TechnicalIndicatorRequestBuilder withTechnicalIndicatorType(TechnicalIndicatorType indicatorType) {
        this.indicatorType = indicatorType;
        return this;
    }

    public TechnicalIndicatorRequestBuilder withInput1(BigDecimal input1) {
        this.queryParameters.put(INPUT_1_NAME, input1.toPlainString());
        return this;
    }

    public TechnicalIndicatorRequestBuilder withInput2(BigDecimal input2) {
        this.queryParameters.put(INPUT_2_NAME, input2.toPlainString());
        return this;
    }

    public TechnicalIndicatorRequestBuilder withInput3(BigDecimal input3) {
        this.queryParameters.put(INPUT_3_NAME, input3.toPlainString());
        return this;
    }

    public TechnicalIndicatorRequestBuilder withInput4(BigDecimal input4) {
        this.queryParameters.put(INPUT_4_NAME, input4.toPlainString());
        return this;
    }

    public TechnicalIndicatorRequestBuilder withRange(ChartRange chartRange) {
        this.queryParameters.put(RANGE_PARAM_NAME, chartRange.getCode());
        return this;
    }

    @Override
    public RestRequest<TechnicalIndicator> build() {
        return RestRequestBuilder.builder().withPath("/stock/{symbol}/indicator/{indicator}").addPathParam("symbol", this.getSymbol()).addPathParam(TECHNICAL_INDICATOR_TYPE_NAME, this.indicatorType.name().toLowerCase()).get().withResponse(new GenericType<TechnicalIndicator>(){}).addQueryParam(this.queryParameters).build();
    }
}

