/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.socket.manager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import io.socket.client.Socket;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import pl.zankowski.iextrading4j.client.mapper.IEXTradingMapperContextResolver;
import pl.zankowski.iextrading4j.client.socket.manager.SocketRequest;
import pl.zankowski.iextrading4j.client.socket.manager.SocketWrapper;

public class SocketManager {
    private final Map<SocketRequest, Socket> socketStore = Maps.newHashMap();
    private final SocketWrapper socketWrapper;
    private final String url;
    private final ObjectMapper objectMapper;

    public SocketManager(SocketWrapper socketWrapper, String url) {
        this.socketWrapper = socketWrapper;
        this.url = url;
        this.objectMapper = new IEXTradingMapperContextResolver().getContext(SocketManager.class);
    }

    public <T> void subscribe(SocketRequest<T> request, Consumer<T> consumer) {
        String url = this.createURL(request);
        try {
            if (this.socketStore.containsKey(request)) {
                return;
            }
            Socket socket = this.socketWrapper.socket(url, true).connect();
            socket.emit("subscribe", new Object[]{this.mapParam(request.getParam())}).on("message", args -> this.processResponse(args, request, consumer));
            this.socketStore.put(request, socket);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private String mapParam(Object param) throws JsonProcessingException {
        if (param instanceof String) {
            return String.valueOf(param);
        }
        return this.objectMapper.writeValueAsString(param);
    }

    public <T> void unsubscribe(SocketRequest<T> request) {
        Socket socket = this.socketStore.remove(request);
        if (socket == null) {
            return;
        }
        socket.disconnect();
    }

    private <T> void processResponse(Object[] args, SocketRequest<T> request, Consumer<T> consumer) {
        Arrays.stream(args).forEach(arg -> {
            try {
                consumer.accept(this.mapObject(arg, request));
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        });
    }

    private <T> T mapObject(Object arg, SocketRequest<T> request) throws IOException {
        return (T)this.objectMapper.readValue(String.valueOf(arg), request.getResponseType());
    }

    private <R> String createURL(SocketRequest<R> restRequest) {
        return this.getServicePath() + restRequest.getPath();
    }

    private String getServicePath() {
        return this.url;
    }
}

