/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.socket.request.marketdata.deep;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Objects;
import java.io.Serializable;
import pl.zankowski.iextrading4j.api.marketdata.Auction;
import pl.zankowski.iextrading4j.api.marketdata.Book;
import pl.zankowski.iextrading4j.api.marketdata.DeepResult;
import pl.zankowski.iextrading4j.api.marketdata.OpHaltStatus;
import pl.zankowski.iextrading4j.api.marketdata.SecurityEvent;
import pl.zankowski.iextrading4j.api.marketdata.SsrStatus;
import pl.zankowski.iextrading4j.api.marketdata.SystemEvent;
import pl.zankowski.iextrading4j.api.marketdata.Trade;
import pl.zankowski.iextrading4j.api.marketdata.TradingStatus;
import pl.zankowski.iextrading4j.client.socket.request.marketdata.deep.DeepMessageType;

public class DeepAsyncResponse<T extends DeepResult>
implements Serializable {
    private final String symbol;
    private final DeepMessageType messageType;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="messageType", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Auction.class, name="auction"), @JsonSubTypes.Type(value=Book.class, name="book"), @JsonSubTypes.Type(value=OpHaltStatus.class, name="ophaltstatus"), @JsonSubTypes.Type(value=SecurityEvent.class, name="securityevent"), @JsonSubTypes.Type(value=SsrStatus.class, name="ssr"), @JsonSubTypes.Type(value=SystemEvent.class, name="systemevent"), @JsonSubTypes.Type(value=TradingStatus.class, name="tradingstatus"), @JsonSubTypes.Type(value=Trade.class, name="trades"), @JsonSubTypes.Type(value=Trade.class, name="tradebreak")})
    private final T data;
    private final Long seq;

    @JsonCreator
    public DeepAsyncResponse(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="messageType") String messageType, @JsonProperty(value="data") T data, @JsonProperty(value="seq") Long seq) {
        this.symbol = symbol;
        this.messageType = DeepMessageType.getMessageType(messageType);
        this.data = data;
        this.seq = seq;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public DeepMessageType getMessageType() {
        return this.messageType;
    }

    public T getData() {
        return this.data;
    }

    public Long getSeq() {
        return this.seq;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeepAsyncResponse that = (DeepAsyncResponse)o;
        return Objects.equal((Object)this.symbol, (Object)that.symbol) && this.messageType == that.messageType && Objects.equal(this.data, that.data) && Objects.equal((Object)this.seq, (Object)that.seq);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.messageType, this.data, this.seq});
    }

    public String toString() {
        return "DeepAsyncResponse{symbol='" + this.symbol + '\'' + ", messageType=" + (Object)((Object)this.messageType) + ", data=" + this.data + ", seq=" + this.seq + '}';
    }
}

