/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.socket.request.marketdata.deep;

import java.util.function.Consumer;
import pl.zankowski.iextrading4j.api.exception.IEXTradingException;
import pl.zankowski.iextrading4j.api.marketdata.Auction;
import pl.zankowski.iextrading4j.api.marketdata.Book;
import pl.zankowski.iextrading4j.api.marketdata.DeepResult;
import pl.zankowski.iextrading4j.api.marketdata.OpHaltStatus;
import pl.zankowski.iextrading4j.api.marketdata.SecurityEvent;
import pl.zankowski.iextrading4j.api.marketdata.SsrStatus;
import pl.zankowski.iextrading4j.api.marketdata.SystemEvent;
import pl.zankowski.iextrading4j.api.marketdata.Trade;
import pl.zankowski.iextrading4j.api.marketdata.TradingStatus;
import pl.zankowski.iextrading4j.client.socket.request.marketdata.deep.DeepAsyncResponse;
import pl.zankowski.iextrading4j.client.socket.request.marketdata.deep.DeepMessageType;

public class DeepConsumerAdapter
implements Consumer<DeepAsyncResponse<DeepResult>> {
    @Override
    public final void accept(DeepAsyncResponse deepAsyncResponse) {
        DeepMessageType messageType = deepAsyncResponse.getMessageType();
        switch (messageType) {
            case TRADING_STATUS: {
                this.acceptTradingStatus(deepAsyncResponse);
                break;
            }
            case AUCTION: {
                this.acceptAuction(deepAsyncResponse);
                break;
            }
            case OP_HALT_STATUS: {
                this.acceptOpHaltStatus(deepAsyncResponse);
                break;
            }
            case SSR_STATUS: {
                this.acceptSsrStatus(deepAsyncResponse);
                break;
            }
            case SECURITY_EVENT: {
                this.acceptSecurityEvent(deepAsyncResponse);
                break;
            }
            case TRADE_BREAK: {
                this.acceptTradeBreak(deepAsyncResponse);
                break;
            }
            case TRADES: {
                this.acceptTrades(deepAsyncResponse);
                break;
            }
            case BOOK: {
                this.acceptBook(deepAsyncResponse);
                break;
            }
            case SYSTEM_EVENT: {
                this.acceptSystemEvent(deepAsyncResponse);
                break;
            }
            default: {
                throw new IEXTradingException("Message type not supported: " + (Object)((Object)messageType));
            }
        }
    }

    public void acceptTradingStatus(DeepAsyncResponse<TradingStatus> tradingStatusResponse) {
    }

    public void acceptAuction(DeepAsyncResponse<Auction> auctionResponse) {
    }

    public void acceptOpHaltStatus(DeepAsyncResponse<OpHaltStatus> opHaltStatusResponse) {
    }

    public void acceptSsrStatus(DeepAsyncResponse<SsrStatus> ssrStatusResponse) {
    }

    public void acceptSecurityEvent(DeepAsyncResponse<SecurityEvent> securityEventResponse) {
    }

    public void acceptTradeBreak(DeepAsyncResponse<Trade> tradeBreakResponse) {
    }

    public void acceptTrades(DeepAsyncResponse<Trade> tradesResponse) {
    }

    public void acceptBook(DeepAsyncResponse<Book> bookResponse) {
    }

    public void acceptSystemEvent(DeepAsyncResponse<SystemEvent> systemEventResponse) {
    }
}

