/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.sse.manager;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.SseEventSource;
import pl.zankowski.iextrading4j.client.IEXCloudToken;
import pl.zankowski.iextrading4j.client.sse.manager.SseClient;
import pl.zankowski.iextrading4j.client.sse.manager.SseRequest;

public class SseManager {
    private static final String TOKEN_QUERY_PARAM = "token";
    private final Map<SseRequest, SseEventSource> sseStore = Maps.newConcurrentMap();
    private final SseClient sseClient;

    public SseManager(SseClient sseClient) {
        this.sseClient = sseClient;
    }

    public <T> void subscribe(SseRequest<T> request, Consumer<T> consumer) {
        String url = this.createURL(request, this.sseClient.getSseClientMetadata().getToken(), this.sseClient.getSseClientMetadata().getUrl());
        SseEventSource eventSource = SseEventSource.target((WebTarget)this.sseClient.getClient().target(url)).build();
        try {
            if (this.sseStore.containsKey(request)) {
                return;
            }
            eventSource.register(event -> {
                Object receivedData = event.readData(request.getResponseType(), MediaType.APPLICATION_JSON_TYPE);
                consumer.accept(receivedData);
            });
            eventSource.open();
            this.sseStore.put(request, eventSource);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public <T> void unsubscribe(SseRequest<T> request) {
        SseEventSource socket = this.sseStore.remove(request);
        if (socket == null) {
            return;
        }
        socket.close();
    }

    private <R> String createURL(SseRequest<R> sseRequest, IEXCloudToken token, String url) {
        return url + this.createPath(sseRequest.getPath(), sseRequest.getPathParams()) + this.createQueryParameters(sseRequest.getQueryParams(), this.resolveUrlToken(sseRequest, token));
    }

    private <R> String resolveUrlToken(SseRequest<R> sseRequest, IEXCloudToken token) {
        return this.resolveToken(sseRequest, token);
    }

    private <R> String resolveToken(SseRequest<R> sseRequest, IEXCloudToken token) {
        return token == null ? null : (sseRequest.getUseSecretToken() != false ? token.getSecretToken() : token.getPublishableToken());
    }

    private String createPath(String originalPath, Map<String, String> pathParams) {
        String path = originalPath;
        for (Map.Entry<String, String> entry : pathParams.entrySet()) {
            path = path.replaceFirst("\\{" + entry.getKey() + "\\}", entry.getValue());
        }
        return path;
    }

    private String createQueryParameters(Map<String, String> queryParams, String publishableToken) {
        if (queryParams.isEmpty() && publishableToken == null) {
            return "";
        }
        HashMap paramsCopy = Maps.newHashMap(queryParams);
        if (publishableToken != null) {
            paramsCopy.put(TOKEN_QUERY_PARAM, publishableToken);
        }
        return paramsCopy.entrySet().stream().map(this::createQueryParam).collect(Collectors.joining("&", "?", ""));
    }

    private String createQueryParam(Map.Entry<String, String> queryParam) {
        return queryParam.getKey() + "=" + queryParam.getValue();
    }
}

