/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.sse.manager;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.client.sse.manager.ISseParamRequestBuilder;
import pl.zankowski.iextrading4j.client.sse.manager.ISsePathRequestBuilder;
import pl.zankowski.iextrading4j.client.sse.manager.ISseResponseTypeRequestBuilder;
import pl.zankowski.iextrading4j.client.sse.manager.SseRequest;

public class SseRequestBuilder<R>
implements ISseParamRequestBuilder<R>,
ISsePathRequestBuilder<R>,
ISseResponseTypeRequestBuilder<R> {
    private GenericType<R> responseType;
    private String path;
    private Map<String, String> headerParams;
    private Map<String, String> pathParams;
    private Map<String, String> queryParams;
    private Boolean useSecretToken = Boolean.FALSE;

    protected SseRequestBuilder() {
        this.headerParams = Maps.newHashMap();
        this.pathParams = Maps.newHashMap();
        this.queryParams = Maps.newHashMap();
    }

    public static <R> ISsePathRequestBuilder<R> builder() {
        return new SseRequestBuilder<R>();
    }

    @Override
    public ISseParamRequestBuilder<R> withResponse(Class<R> responseType) {
        this.responseType = new GenericType(responseType);
        return this;
    }

    @Override
    public ISseResponseTypeRequestBuilder<R> addPathParam(String key, String value) {
        this.pathParams.put(key, value);
        return this;
    }

    @Override
    public ISseParamRequestBuilder<R> withResponse(GenericType<R> responseType) {
        this.responseType = responseType;
        return this;
    }

    @Override
    public ISseParamRequestBuilder<R> addHeaderParam(String key, String value) {
        this.headerParams.put(key, value);
        return this;
    }

    @Override
    public ISseParamRequestBuilder<R> addQueryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    @Override
    public ISseParamRequestBuilder<R> addQueryParam(Map<String, String> queryParams) {
        this.queryParams.putAll(queryParams);
        return this;
    }

    @Override
    public ISseParamRequestBuilder<R> withSecretToken() {
        this.useSecretToken = true;
        return this;
    }

    @Override
    public ISseResponseTypeRequestBuilder<R> withPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public SseRequest<R> build() {
        return new SseRequest<R>(this.responseType, this.path, this.headerParams, this.pathParams, this.queryParams, this.useSecretToken);
    }
}

