/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import [Ljava.lang.String;;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.javac.IsolatedClassLoader;

public class JavacCompiler
extends AbstractCompiler {
    static final int OUTPUT_BUFFER_SIZE = 1024;

    public List compile(CompilerConfiguration config) throws Exception {
        List sourceLocations;
        List classpathEntries;
        String[] sources;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sources = this.getSourceFiles(config)).length == 0) {
            return Collections.EMPTY_LIST;
        }
        System.out.println("Compiling " + sources.length + " source file" + (sources.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        Map compilerOptions = config.getCompilerOptions();
        ArrayList<String> args = new ArrayList<String>(sources.length + 5 + compilerOptions.size() * 2);
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        if (config.isNoWarn()) {
            args.add("-nowarn");
        }
        if ((classpathEntries = config.getClasspathEntries()) != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(this.getPathString(classpathEntries));
        }
        if (config.isDebug()) {
            args.add("-g");
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args.add("-sourcepath");
            args.add(this.getPathString(sourceLocations));
        }
        Iterator it = compilerOptions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            args.add((String)entry.getKey());
            if (entry.getValue() == null) continue;
            args.add((String)entry.getValue());
        }
        for (int i = 0; i < sources.length; ++i) {
            args.add(sources[i]);
        }
        IsolatedClassLoader cl = new IsolatedClassLoader();
        File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
        cl.addURL(toolsJar.toURL());
        Class c = cl.loadClass("sun.tools.javac.Main");
        Constructor cons = c.getConstructor(OutputStream.class, String.class);
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        Object compiler = cons.newInstance(err, "javac");
        Method compile = c.getMethod("compile", String;.class);
        Boolean ok = (Boolean)compile.invoke(compiler, new Object[]{args.toArray(new String[0])});
        List messages = this.parseModernStream(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(err.toByteArray()))));
        if (!ok.booleanValue() && messages.isEmpty()) {
            messages.add(new CompilerError("Failure executing javac, but could not parse the error:\n\n" + err.toString(), true));
        }
        return messages;
    }

    protected List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    return errors;
                }
                if (buffer.length() == 0 && line.startsWith("error: ")) {
                    errors.add(new CompilerError(line, true));
                    continue;
                }
                if (buffer.length() == 0 && line.startsWith("Note: ")) continue;
                buffer.append(line);
                buffer.append('\n');
            } while (!line.endsWith("^"));
            errors.add(this.parseModernError(buffer.toString()));
        }
    }

    private CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        try {
            String pointer;
            int startcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            String message = tokens.nextToken("\n").substring(1);
            String context = tokens.nextToken("\n");
            int endcolumn = context.indexOf(" ", startcolumn = (pointer = tokens.nextToken("\n")).indexOf("^"));
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, true, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException nse) {
            return new CompilerError("no more tokens - could not parse error message: " + error, true);
        }
        catch (Exception nse) {
            return new CompilerError("could not parse error message: " + error, true);
        }
    }

    public String toString() {
        return "Sun Javac Compiler";
    }
}

