/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Field;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.composite.CompositeConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public abstract class AbstractCompositeConverter
implements CompositeConverter {
    private static final String IMPLEMENTATION = "implementation";

    public abstract boolean canConvert(Class var1);

    public abstract Object fromConfiguration(ConverterLookup var1, PlexusConfiguration var2, Field var3, ClassLoader var4) throws ComponentConfigurationException;

    protected Class getClassForImplementationHint(Class type, PlexusConfiguration configuration, ClassLoader classLoader, ComponentDescriptor componentDescriptor) throws ComponentConfigurationException {
        Class<?> retValue = type;
        String implementation = configuration.getAttribute(IMPLEMENTATION, null);
        if (implementation != null) {
            try {
                retValue = classLoader.loadClass(implementation);
            }
            catch (ClassNotFoundException e) {
                String msg = "Class name which was explicitly given in configuration using 'implementation' attribute: '" + implementation + "' cannot be loaded: " + e.getMessage();
                throw new ComponentConfigurationException(msg);
            }
        }
        return retValue;
    }

    protected Object instantiateObject(Class clazz) throws ComponentConfigurationException {
        Object retValue = null;
        try {
            retValue = clazz.newInstance();
            return retValue;
        }
        catch (Exception exception) {
            throw new ComponentConfigurationException("Class '" + clazz.getName() + "' cannot be instantiated");
        }
    }

    protected Object instantiateObject(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class clazz = this.loadClass(classname, classLoader);
        Object retValue = this.instantiateObject(clazz);
        return retValue;
    }

    protected Class loadClass(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue = null;
        try {
            retValue = classLoader.loadClass(classname);
        }
        catch (Exception exception) {
            throw new ComponentConfigurationException("Class '" + classname + "' cannot be loaded");
        }
        return retValue;
    }
}

