/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.lookup;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.basic.BooleanConverter;
import org.codehaus.plexus.component.configurator.converters.basic.ByteConverter;
import org.codehaus.plexus.component.configurator.converters.basic.CharConverter;
import org.codehaus.plexus.component.configurator.converters.basic.DateConverter;
import org.codehaus.plexus.component.configurator.converters.basic.DoubleConverter;
import org.codehaus.plexus.component.configurator.converters.basic.FileConverter;
import org.codehaus.plexus.component.configurator.converters.basic.FloatConverter;
import org.codehaus.plexus.component.configurator.converters.basic.IntConverter;
import org.codehaus.plexus.component.configurator.converters.basic.LongConverter;
import org.codehaus.plexus.component.configurator.converters.basic.ShortConverter;
import org.codehaus.plexus.component.configurator.converters.basic.StringBufferConverter;
import org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import org.codehaus.plexus.component.configurator.converters.composite.CollectionConverter;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.converters.composite.PlexusConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;

public class DefaultConverterLookup
implements ConverterLookup {
    private List converters = new LinkedList();
    private Map converterMap = new HashMap();

    public DefaultConverterLookup() {
        this.registerDefaultBasicConverters();
        this.registerDefaultCompositeConverters();
    }

    public ConfigurationConverter lookupConverterForType(Class type) throws ComponentConfigurationException {
        ConfigurationConverter retValue = null;
        if (this.converterMap.containsKey(type)) {
            retValue = (ConfigurationConverter)this.converterMap.get(type);
        } else {
            Iterator iterator = this.converters.iterator();
            while (iterator.hasNext()) {
                ConfigurationConverter converter = (ConfigurationConverter)iterator.next();
                if (!converter.canConvert(type)) continue;
                retValue = converter;
                break;
            }
            this.converterMap.put(type, retValue);
        }
        if (retValue == null) {
            throw new ComponentConfigurationException("Configuration converter lookup failed");
        }
        return retValue;
    }

    public void registerConverter(ConfigurationConverter converter) {
        this.converters.add(converter);
    }

    private void registerDefaultBasicConverters() {
        this.registerConverter(new BooleanConverter());
        this.registerConverter(new ByteConverter());
        this.registerConverter(new CharConverter());
        this.registerConverter(new DoubleConverter());
        this.registerConverter(new FloatConverter());
        this.registerConverter(new IntConverter());
        this.registerConverter(new LongConverter());
        this.registerConverter(new ShortConverter());
        this.registerConverter(new StringBufferConverter());
        this.registerConverter(new StringConverter());
        this.registerConverter(new DateConverter());
        this.registerConverter(new FileConverter());
    }

    private void registerDefaultCompositeConverters() {
        this.registerConverter(new CollectionConverter());
        this.registerConverter(new PropertiesConverter());
        this.registerConverter(new PlexusConfigurationConverter());
        this.registerConverter(new ObjectWithFieldsConverter());
    }
}

