/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public abstract class AbstractComponentDiscoverer
implements ComponentDiscoverer {
    private ComponentDiscovererManager manager;

    protected abstract ComponentSetDescriptor createComponentDescriptors(Reader var1, String var2) throws Exception;

    public List findComponents(Context context, ClassRealm classRealm) {
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        try {
            Enumeration e = classRealm.findResources(this.getComponentDescriptorLocation());
            while (e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                InterpolationFilterReader input = new InterpolationFilterReader(new InputStreamReader(url.openStream()), new ContextMapAdapter(context));
                String descriptor = IOUtil.toString(input);
                ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors(new StringReader(descriptor), url.toString());
                componentSetDescriptors.add(componentSetDescriptor);
                ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor);
                this.manager.fireComponentDiscoveryEvent(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return componentSetDescriptors;
    }

    protected abstract String getComponentDescriptorLocation();

    public void setManager(ComponentDiscovererManager manager) {
        this.manager = manager;
    }
}

