/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.exception.ComponentImplementationNotFoundException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private static String COMPONENTS = "components";
    private static String COMPONENT = "component";
    private PlexusConfiguration configuration;
    private Map componentDescriptorMaps;
    private Map componentDescriptors = new HashMap();
    private CompositionResolver compositionResolver;
    private ClassRealm classRealm;

    public DefaultComponentRepository() {
        this.componentDescriptorMaps = new HashMap();
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        try {
            this.validateComponentDescriptor(componentDescriptor);
        }
        catch (ComponentImplementationNotFoundException e) {
            throw new ComponentRepositoryException("Component descriptor validation failed: ", e);
        }
        String roleHint = componentDescriptor.getRoleHint();
        if (roleHint != null) {
            String role = componentDescriptor.getRole();
            HashMap<String, ComponentDescriptor> map = (HashMap<String, ComponentDescriptor>)this.componentDescriptorMaps.get(role);
            if (map == null) {
                map = new HashMap<String, ComponentDescriptor>();
                this.componentDescriptorMaps.put(role, map);
            }
            map.put(roleHint, componentDescriptor);
        }
        try {
            this.compositionResolver.addComponentDescriptor(componentDescriptor);
        }
        catch (CompositionException e) {
            throw new ComponentRepositoryException(e.getMessage(), e);
        }
        this.componentDescriptors.put(componentDescriptor.getComponentKey(), componentDescriptor);
    }

    public void addComponentDescriptor(PlexusConfiguration configuration) throws ComponentRepositoryException {
        ComponentDescriptor componentDescriptor = null;
        try {
            componentDescriptor = PlexusTools.buildComponentDescriptor(configuration);
        }
        catch (Exception e) {
            throw new ComponentRepositoryException("Cannot unmarshall component descriptor:", e);
        }
        this.addComponentDescriptor(componentDescriptor);
    }

    public void configure(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public List getComponentDependencies(ComponentDescriptor componentDescriptor) {
        return this.compositionResolver.getRequirements(componentDescriptor.getComponentKey());
    }

    public ComponentDescriptor getComponentDescriptor(String key) {
        return (ComponentDescriptor)this.componentDescriptors.get(key);
    }

    public Map getComponentDescriptorMap(String role) {
        return (Map)this.componentDescriptorMaps.get(role);
    }

    protected PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean hasComponent(String role) {
        return this.componentDescriptors.containsKey(role);
    }

    public boolean hasComponent(String role, String roleHint) {
        return this.componentDescriptors.containsKey(String.valueOf(role) + roleHint);
    }

    public void initialize() throws Exception {
        this.initializeComponentDescriptors();
    }

    public void initializeComponentDescriptors() throws Exception {
        this.initializeComponentDescriptorsFromUserConfiguration();
    }

    private void initializeComponentDescriptorsFromUserConfiguration() throws Exception {
        PlexusConfiguration[] componentConfigurations = this.configuration.getChild(COMPONENTS).getChildren(COMPONENT);
        int i = 0;
        while (i < componentConfigurations.length) {
            this.addComponentDescriptor(componentConfigurations[i]);
            ++i;
        }
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public void validateComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentImplementationNotFoundException {
    }
}

