/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.processor.AbstractConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;

public class DirectoryConfigurationResourceHandler
extends AbstractConfigurationResourceHandler {
    public String getId() {
        return "directory-configuration-resource";
    }

    public PlexusConfiguration[] handleRequest(Map parameters) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        File f = new File(this.getSource(parameters));
        if (!f.exists()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + f + " cannot be found.");
        }
        if (!f.isDirectory()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + f + " is not a directory.");
        }
        String includes = (String)parameters.get("includes");
        if (includes == null) {
            includes = "**/*.xml";
        }
        String excludes = (String)parameters.get("excludes");
        try {
            List files = FileUtils.getFiles(f, includes, excludes);
            PlexusConfiguration[] configurations = new PlexusConfiguration[files.size()];
            int i = 0;
            while (i < configurations.length) {
                PlexusConfiguration configuration;
                File configurationFile = (File)files.get(i);
                configurations[i] = configuration = PlexusTools.buildConfiguration(new FileReader(configurationFile));
                ++i;
            }
            return configurations;
        }
        catch (Exception e) {
            throw new ConfigurationProcessingException(e);
        }
    }
}

