/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.xml;

import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class XmlPlexusConfiguration
implements PlexusConfiguration {
    private Xpp3Dom dom;

    public XmlPlexusConfiguration(String name) {
        this.dom = new Xpp3Dom(name);
    }

    public XmlPlexusConfiguration(Xpp3Dom dom) {
        this.dom = dom;
    }

    public void addAllChildren(PlexusConfiguration other) {
        PlexusConfiguration[] children = other.getChildren();
        int i = 0;
        while (i < children.length) {
            this.addChild(children[i]);
            ++i;
        }
    }

    public void addChild(PlexusConfiguration configuration) {
        this.dom.addChild(((XmlPlexusConfiguration)configuration).getXpp3Dom());
    }

    private void attributes(PlexusConfiguration c, StringBuffer sb) {
        String[] names = c.getAttributeNames();
        int i = 0;
        while (i < names.length) {
            sb.append(' ').append(names[i]).append('=').append('\"').append(c.getAttribute(names[i], null)).append('\"');
            ++i;
        }
    }

    private void display(PlexusConfiguration c, StringBuffer sb, int depth) {
        sb.append(this.indent(depth)).append('<').append(c.getName()).append('>').append('\n');
        int count = c.getChildCount();
        int i = 0;
        while (i < count) {
            PlexusConfiguration child = c.getChild(i);
            int childCount = child.getChildCount();
            ++depth;
            if (childCount > 0) {
                this.display(child, sb, depth);
            } else {
                try {
                    String value = child.getValue();
                    if (value != null) {
                        sb.append(this.indent(depth)).append('<').append(child.getName());
                        this.attributes(child, sb);
                        sb.append('>').append(child.getValue()).append('<').append('/').append(child.getName()).append('>').append('\n');
                    } else {
                        sb.append(this.indent(depth)).append('<').append(child.getName());
                        this.attributes(child, sb);
                        sb.append('/').append('>').append("\n");
                    }
                }
                catch (Exception exception) {}
            }
            --depth;
            ++i;
        }
        sb.append(this.indent(depth)).append('<').append('/').append(c.getName()).append('>').append('\n');
    }

    public String getAttribute(String name) {
        return this.dom.getAttribute(name);
    }

    public String getAttribute(String name, String defaultValue) {
        String attribute = this.getAttribute(name);
        if (attribute == null) {
            attribute = defaultValue;
        }
        return attribute;
    }

    public String[] getAttributeNames() {
        return this.dom.getAttributeNames();
    }

    public PlexusConfiguration getChild(int i) {
        return new XmlPlexusConfiguration(this.dom.getChild(i));
    }

    public PlexusConfiguration getChild(String name) {
        return this.getChild(name, true);
    }

    public PlexusConfiguration getChild(String name, boolean createChild) {
        Xpp3Dom child = this.dom.getChild(name);
        if (child == null) {
            if (createChild) {
                child = new Xpp3Dom(name);
                this.dom.addChild(child);
            } else {
                return null;
            }
        }
        return new XmlPlexusConfiguration(child);
    }

    public int getChildCount() {
        return this.dom.getChildCount();
    }

    public PlexusConfiguration[] getChildren() {
        Xpp3Dom[] doms = this.dom.getChildren();
        PlexusConfiguration[] children = new XmlPlexusConfiguration[doms.length];
        int i = 0;
        while (i < children.length) {
            children[i] = new XmlPlexusConfiguration(doms[i]);
            ++i;
        }
        return children;
    }

    public PlexusConfiguration[] getChildren(String name) {
        Xpp3Dom[] doms = this.dom.getChildren(name);
        PlexusConfiguration[] children = new XmlPlexusConfiguration[doms.length];
        int i = 0;
        while (i < children.length) {
            children[i] = new XmlPlexusConfiguration(doms[i]);
            ++i;
        }
        return children;
    }

    public String getName() {
        return this.dom.getName();
    }

    public String getValue() {
        return this.dom.getValue();
    }

    public String getValue(String defaultValue) {
        String value = this.dom.getValue();
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Xpp3Dom getXpp3Dom() {
        return this.dom;
    }

    private String indent(int depth) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public void setAttribute(String name, String value) {
        this.dom.setAttribute(name, value);
    }

    public void setValue(String value) {
        this.dom.setValue(value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int depth = 0;
        this.display(this, sb, depth);
        return sb.toString();
    }
}

