/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.context;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;

public class DefaultContext
implements Context {
    private static Hidden HIDDEN_MAKER = new Hidden();
    private Map contextData;
    private Context parent;
    private boolean readOnly;

    public DefaultContext() {
        this((Context)null);
    }

    public DefaultContext(Map contextData) {
        this(contextData, null);
    }

    public DefaultContext(Map contextData, Context parent) {
        this.parent = parent;
        this.contextData = contextData;
    }

    public DefaultContext(Context parent) {
        this(new Hashtable(), parent);
    }

    protected void checkWriteable() throws IllegalStateException {
        if (this.readOnly) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    public boolean contains(Object key) {
        Object data = this.contextData.get(key);
        if (data != null) {
            return !(data instanceof Hidden);
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(key);
    }

    public Object get(Object key) throws ContextException {
        Object data = this.contextData.get(key);
        if (data != null) {
            if (data instanceof Hidden) {
                throw new ContextException("Unable to locate " + key);
            }
            return data;
        }
        if (this.parent == null) {
            throw new ContextException("Unable to resolve context key: " + key);
        }
        return this.parent.get(key);
    }

    protected Map getContextData() {
        return this.contextData;
    }

    protected Context getParent() {
        return this.parent;
    }

    public void hide(Object key) throws IllegalStateException {
        this.checkWriteable();
        this.contextData.put(key, HIDDEN_MAKER);
    }

    public void makeReadOnly() {
        this.readOnly = true;
    }

    public void put(Object key, Object value) throws IllegalStateException {
        this.checkWriteable();
        if (value == null) {
            this.contextData.remove(key);
        } else {
            this.contextData.put(key, value);
        }
    }

    private static class Hidden
    implements Serializable {
        Hidden() {
        }
    }
}

