/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.embed;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.PlexusEmbedder;
import org.codehaus.plexus.util.PropertyUtils;

public class Embedder
implements PlexusEmbedder {
    private Reader configurationReader;
    private Properties properties;
    private final DefaultPlexusContainer container = new DefaultPlexusContainer();
    private boolean embedderStarted = false;
    private boolean embedderStopped = false;

    public synchronized void addContextValue(Object key, Object value) {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        this.container.addContextValue(key, value);
    }

    public synchronized PlexusContainer getContainer() {
        if (!this.embedderStarted) {
            throw new IllegalStateException("Embedder must be started");
        }
        return this.container;
    }

    public boolean hasComponent(String role) {
        return this.getContainer().hasComponent(role);
    }

    public boolean hasComponent(String role, String id) {
        return this.getContainer().hasComponent(role, id);
    }

    protected synchronized void initializeContext() {
        Set keys = ((Hashtable)this.properties).keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = this.properties.getProperty(key);
            this.container.addContextValue(key, value);
        }
    }

    public Object lookup(String role) throws ComponentLookupException {
        return this.getContainer().lookup(role);
    }

    public Object lookup(String role, String id) throws ComponentLookupException {
        return this.getContainer().lookup(role, id);
    }

    public void release(Object service) throws Exception {
        this.getContainer().release(service);
    }

    public synchronized void setClassWorld(ClassWorld classWorld) {
        this.container.setClassWorld(classWorld);
    }

    public synchronized void setConfiguration(Reader configuration) throws IOException {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        this.configurationReader = configuration;
    }

    public synchronized void setConfiguration(URL configuration) throws IOException {
        if (this.embedderStarted || this.embedderStopped) {
            throw new IllegalStateException("Embedder has already been started");
        }
        this.configurationReader = new InputStreamReader(configuration.openStream());
    }

    public synchronized void setProperties(File file) {
        this.properties = PropertyUtils.loadProperties(file);
    }

    public synchronized void setProperties(Properties properties) {
        this.properties = properties;
    }

    public synchronized void start() throws Exception {
        if (this.embedderStarted) {
            throw new IllegalStateException("Embedder already started");
        }
        if (this.embedderStopped) {
            throw new IllegalStateException("Embedder cannot be restarted");
        }
        if (this.configurationReader != null) {
            this.container.setConfigurationResource(this.configurationReader);
        }
        if (this.properties != null) {
            this.initializeContext();
        }
        this.container.initialize();
        this.embedderStarted = true;
        this.container.start();
    }

    public synchronized void start(ClassWorld classWorld) throws Exception {
        this.container.setClassWorld(classWorld);
        this.start();
    }

    public synchronized void stop() throws Exception {
        if (this.embedderStopped) {
            throw new IllegalStateException("Embedder already stopped");
        }
        if (!this.embedderStarted) {
            throw new IllegalStateException("Embedder not started");
        }
        this.container.dispose();
        this.embedderStarted = false;
        this.embedderStopped = true;
    }
}

