/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PrettyPrintXMLWriter
implements XMLWriter {
    private PrintWriter writer;
    private LinkedList elementStack = new LinkedList();
    private boolean tagInProgress;
    private int depth;
    private String lineIndenter;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;

    public PrettyPrintXMLWriter(PrintWriter writer) {
        this(writer, "  ");
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndenter) {
        this.writer = writer;
        this.lineIndenter = lineIndenter;
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndenter) {
        this(new PrintWriter(writer), lineIndenter);
    }

    public void addAttribute(String key, String value) {
        this.write(" ");
        this.write(key);
        this.write("=\"");
        this.write(value);
        this.write("\"");
    }

    public void endElement() {
        --this.depth;
        if (this.tagIsEmpty) {
            this.write("/");
            this.readyForNewLine = false;
            this.finishTag();
            this.elementStack.removeLast();
        } else {
            this.finishTag();
            this.write("</" + this.elementStack.removeLast() + ">");
        }
        this.readyForNewLine = true;
    }

    protected void endOfLine() {
        this.write("\n");
        int i = 0;
        while (i < this.depth) {
            this.write(this.lineIndenter);
            ++i;
        }
    }

    private void finishTag() {
        if (this.tagInProgress) {
            this.write(">");
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    public void startElement(String name) {
        this.tagIsEmpty = false;
        this.finishTag();
        this.write("<");
        this.write(name);
        this.elementStack.addLast(name);
        this.tagInProgress = true;
        ++this.depth;
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    private void write(String str) {
        this.writer.write(str);
    }

    public void writeMarkup(String text) {
        this.writeText(text, false);
    }

    public void writeText(String text) {
        this.writeText(text, true);
    }

    private void writeText(String text, boolean escapeHtml) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        if (escapeHtml) {
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
        }
        this.write(text);
    }
}

