package plus.easydo.starter.file.annotation;


import org.springframework.context.annotation.Import;
import plus.easydo.starter.file.FileStoreAutoConfiguration;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 使用此注解需要再配置文件中指定需要开启的文件功能 具体参考 FileStoreAutoConfiguration中的 @ConditionalOnProperty注解
 * @author yuzhanfeng
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
@Import(FileStoreAutoConfiguration.class)
public @interface EnableFileStoreServer {

}
