/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.file;

import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import plus.easydo.starter.file.FileStoreObject;

public class FileStoreUtil {
    public static final String SLASH = "/";

    public static FileStoreObject<String, MultipartFile> buildFileStoreObject(String groupName, File file) {
        FileStoreObject<String, MultipartFile> fileStoreObject = new FileStoreObject<String, MultipartFile>();
        fileStoreObject.setIndex(file.getName());
        fileStoreObject.setFile(FileStoreUtil.fileToMultipartFile(file));
        fileStoreObject.setFileName(file.getName());
        fileStoreObject.setGroupName(groupName);
        fileStoreObject.setFilePath(file.getPath());
        return fileStoreObject;
    }

    public static String endWithSeparator(String str) {
        if (!StrUtil.endWith((CharSequence)str, (CharSequence)File.separator)) {
            str = str + File.separator;
        }
        return str;
    }

    public static String endWithSlash(String str) {
        if (!StrUtil.endWith((CharSequence)str, (CharSequence)SLASH)) {
            str = str + SLASH;
        }
        return str;
    }

    public static MultipartFile fileToMultipartFile(File file) {
        FileItem fileItem = FileStoreUtil.createFileItem(file);
        return new CommonsMultipartFile(fileItem);
    }

    public static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }
}

