/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.file.local;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import plus.easydo.starter.file.FileStoreObject;
import plus.easydo.starter.file.FileStoreUtil;
import plus.easydo.starter.file.exception.FileStoreException;
import plus.easydo.starter.file.local.config.LocalFileProperties;

@Component
@EnableConfigurationProperties(value={LocalFileProperties.class})
public class LocalFileStoreTemplate {
    private static String separator = File.separator;
    @Autowired
    LocalFileProperties localFileProperties;

    public String getDefaultGroupName() {
        return this.localFileProperties.getDefaultGroupName();
    }

    public InputStream getFile(String groupName, String fileIndex) {
        String storePath = this.localFileProperties.getStorePath();
        File file = FileUtil.file((String)(storePath + separator + groupName + separator), (String)fileIndex);
        return FileUtil.getInputStream((File)file);
    }

    public Boolean remove(String groupName, String fileIndex) {
        String storePath = this.localFileProperties.getStorePath();
        return FileUtil.del((String)(storePath + separator + groupName + separator + fileIndex));
    }

    public FileStoreObject<String, MultipartFile> copy(String groupName, String index, String targetGroupName, String targetIndex) {
        String storePath = this.localFileProperties.getStorePath();
        String source = storePath + separator + groupName + separator + index;
        String target = storePath + separator + targetGroupName + separator + targetIndex;
        File file = FileUtil.copy((String)source, (String)target, (boolean)true);
        return FileStoreUtil.buildFileStoreObject(groupName, file);
    }

    public FileStoreObject<String, MultipartFile> move(String groupName, String index, String targetGroupName, String targetIndex) {
        String storePath = this.localFileProperties.getStorePath();
        String source = storePath + separator + groupName + separator + index;
        String target = storePath + separator + targetGroupName + separator + targetIndex;
        File file = FileUtil.file((String)source);
        File targetFile = FileUtil.file((String)target);
        FileUtil.move((File)file, (File)targetFile, (boolean)true);
        return FileStoreUtil.buildFileStoreObject(groupName, FileUtil.file((String)target));
    }

    public void save(String groupName, String filePath, String fileName, MultipartFile file) {
        String path = this.localFileProperties.getStorePath() + File.separator + groupName + File.separator + FileStoreUtil.endWithSeparator(filePath);
        File files = FileUtil.file((String)path, (String)fileName);
        try {
            FileUtil.writeFromStream((InputStream)file.getInputStream(), (File)files);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FileStoreException("\u5b58\u50a8\u6587\u4ef6\u53d1\u751f\u5f02\u5e38");
        }
    }
}

