/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core;

import java.io.IOException;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.Constants;
import org.apache.pluto.core.InternalPortletRequest;
import org.apache.pluto.core.InternalPortletResponse;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.ControllerObjectAccess;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionCtrl;
import org.apache.pluto.portlet.PortletUtils;
import org.apache.pluto.services.information.InformationProviderAccess;

public class PortletServlet
extends HttpServlet {
    private boolean portletInitialized = false;
    private Portlet portletClass = null;
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.portletInitialized = false;
        String classString = config.getInitParameter("portlet-class");
        try {
            this.portletClass = (Portlet)Thread.currentThread().getContextClassLoader().loadClass(classString).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        String portletGUID = config.getInitParameter("portlet-guid");
        PortletDefinition portletDefinition = InformationProviderAccess.getStaticProvider().getPortletDefinition(portletGUID);
        if (portletDefinition == null) {
            throw new ServletException("portlet definition not found from GUID: " + portletGUID);
        }
        PortletDefinitionCtrl portletDefCtrl = (PortletDefinitionCtrl)ControllerObjectAccess.get(portletDefinition);
        portletDefCtrl.setPortletClassLoader(Thread.currentThread().getContextClassLoader());
        this.portletContext = PortletObjectAccess.getPortletContext(config.getServletContext(), portletDefinition.getPortletApplicationDefinition());
        this.portletConfig = PortletObjectAccess.getPortletConfig(config, this.portletContext, portletDefinition);
        try {
            this.portletClass.init(this.portletConfig);
        }
        catch (PortletException e) {
            throw new ServletException((Throwable)e);
        }
        this.portletInitialized = true;
    }

    public void init() throws ServletException {
    }

    public final ServletConfig getServletConfig() {
        return super.getServletConfig();
    }

    public final String getInitParameter(String name) {
        return this.getServletConfig().getInitParameter(name);
    }

    public final Enumeration getInitParameterNames() {
        return this.getServletConfig().getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected long getLastModified(HttpServletRequest req) {
        return -1L;
    }

    public String getServletInfo() {
        return "";
    }

    public final void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        super.service(request, response);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doTrace(req, resp);
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.portletInitialized) {
            throw new ServletException("this portlet uses the <load-on-startup> flag. You have to turn it off");
        }
        try {
            block8: {
                try {
                    request.setAttribute("javax.portlet.config", (Object)this.portletConfig);
                    Integer method_id = (Integer)request.getAttribute("org.apache.pluto.core.method");
                    if (method_id == Constants.METHOD_RENDER) {
                        RenderRequest renderRequest = (RenderRequest)request.getAttribute("javax.portlet.request");
                        RenderResponse renderResponse = (RenderResponse)request.getAttribute("javax.portlet.response");
                        this.prepareRenderRequest(renderRequest, request);
                        this.prepareRenderResponse(renderResponse, request, response);
                        this.portletClass.render(renderRequest, renderResponse);
                        break block8;
                    }
                    if (method_id == Constants.METHOD_ACTION) {
                        ActionRequest actionRequest = (ActionRequest)request.getAttribute("javax.portlet.request");
                        ActionResponse actionResponse = (ActionResponse)request.getAttribute("javax.portlet.response");
                        this.prepareActionRequest(actionRequest, request);
                        this.prepareActionResponse(actionResponse, request, response);
                        this.portletClass.processAction(actionRequest, actionResponse);
                        break block8;
                    }
                    if (method_id == Constants.METHOD_NOOP) {
                        // empty if block
                    }
                }
                catch (PortletException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            request.removeAttribute("javax.portlet.config");
            throw throwable;
        }
        request.removeAttribute("javax.portlet.config");
    }

    public void destroy() {
        super.destroy();
    }

    private void prepareActionRequest(ActionRequest portletRequest, HttpServletRequest servletRequest) {
        InternalPortletRequest internalPortletRequest = PortletUtils.getInternalRequest((PortletRequest)portletRequest);
        internalPortletRequest.lateInit(servletRequest);
    }

    private void prepareRenderRequest(RenderRequest portletRequest, HttpServletRequest servletRequest) {
        InternalPortletRequest internalPortletRequest = PortletUtils.getInternalRequest((PortletRequest)portletRequest);
        internalPortletRequest.lateInit(servletRequest);
    }

    private void prepareRenderResponse(RenderResponse portletResponse, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        InternalPortletResponse internalPortletResponse = PortletUtils.getInternalResponse(portletResponse);
        internalPortletResponse.lateInit(servletRequest, servletResponse);
    }

    private void prepareActionResponse(ActionResponse portletResponse, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        InternalPortletResponse internalPortletResponse = PortletUtils.getInternalResponse(portletResponse);
        internalPortletResponse.lateInit(servletRequest, servletResponse);
    }
}

