/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.core.InternalActionResponse;
import org.apache.pluto.core.impl.PortletResponseImpl;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.InformationProviderAccess;

public class ActionResponseImpl
extends PortletResponseImpl
implements ActionResponse,
InternalActionResponse {
    boolean redirectAllowed = true;
    private Map renderParameters = new HashMap();

    public ActionResponseImpl(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(portletWindow, servletRequest, servletResponse);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!InformationProviderAccess.getDynamicProvider(this.getHttpServletRequest()).isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        InformationProviderAccess.getPortletActionProvider(this.getHttpServletRequest()).changePortletWindowState(this.getPortletWindow(), windowState);
        this.redirectAllowed = false;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!InformationProviderAccess.getDynamicProvider(this.getHttpServletRequest()).isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        InformationProviderAccess.getPortletActionProvider(this.getHttpServletRequest()).changePortletMode(this.getPortletWindow(), portletMode);
        this.redirectAllowed = false;
    }

    public void sendRedirect(String location) throws IOException {
        if (this.redirectAllowed) {
            if (location != null) {
                try {
                    HttpServletResponse redirectResponse = this._getHttpServletResponse();
                    while (redirectResponse instanceof HttpServletResponseWrapper) {
                        redirectResponse = (HttpServletResponse)((HttpServletResponseWrapper)redirectResponse).getResponse();
                    }
                    URL url = new URL(location);
                    location = redirectResponse.encodeRedirectURL(url.toString());
                    redirectResponse.sendRedirect(location);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Can't invoke sendRedirect() because given url is unvalid");
                }
            }
        } else {
            throw new IllegalStateException("Can't invoke sendRedirect() after certain methods have been called");
        }
    }

    public void setRenderParameters(Map parameters) {
        this.renderParameters.putAll(parameters);
        this.redirectAllowed = false;
    }

    public void setRenderParameter(String key, String value) {
        this.renderParameters.put(key, new String[]{value});
        this.redirectAllowed = false;
    }

    public void setRenderParameter(String key, String[] values) {
        this.renderParameters.put(key, values);
        this.redirectAllowed = false;
    }

    public Map getRenderParameters() {
        return this.renderParameters;
    }
}

