/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.portlet.PortalContext;
import org.apache.pluto.util.Enumerator;

public class PortalContextImpl
implements PortalContext {
    private String info = "apache-pluto.1.0";
    private Vector modes;
    private Vector states;
    private HashMap properties = new HashMap();

    public PortalContextImpl() {
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        return (String)this.properties.get(name);
    }

    public Enumeration getPropertyNames() {
        return new Enumerator(this.properties.keySet());
    }

    public Enumeration getSupportedPortletModes() {
        return this.modes.elements();
    }

    public Enumeration getSupportedWindowStates() {
        return this.states.elements();
    }

    public String getPortalInfo() {
        return this.info;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        this.properties.put(name, value);
    }

    public void setSupportedPortletModes(Enumeration portletModes) {
        Vector v = new Vector();
        while (portletModes.hasMoreElements()) {
            v.add(portletModes.nextElement());
        }
        this.modes = v;
    }

    public void setSupportedWindowStates(Enumeration windowStates) {
        Vector v = new Vector();
        while (windowStates.hasMoreElements()) {
            v.add(windowStates.nextElement());
        }
        this.states = v;
    }

    public void reset(String portalInfo) {
        this.info = new String(portalInfo);
        this.modes = this.getDefaultModes();
        this.states = this.getDefaultStates();
        this.properties.clear();
    }

    private Vector getDefaultModes() {
        Vector<String> m = new Vector<String>();
        m.add("edit");
        m.add("view");
        m.add("help");
        return m;
    }

    private Vector getDefaultStates() {
        Vector<String> s = new Vector<String>();
        s.add("minimized");
        s.add("normal");
        s.add("maximized");
        return s;
    }
}

