/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.UnmodifiableException;
import javax.portlet.ValidatorException;
import org.apache.pluto.om.ControllerObjectAccess;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceCtrl;
import org.apache.pluto.om.common.PreferenceSetCtrl;
import org.apache.pluto.om.common.ValidatorDefinition;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;

public class PortletPreferencesImpl
implements PortletPreferences {
    private PortletEntity portletEntity;
    private HashMap preferenceChanges = new HashMap();

    public PortletPreferencesImpl(PortletEntity portletEntity) {
        this.portletEntity = portletEntity;
    }

    public boolean isModifiable(String key) {
        boolean isMod = false;
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        Preference preference = this.portletEntity.getPreferenceSet().get(key);
        if (preference == null) {
            preference = this.portletEntity.getPortletDefinition().getPreferenceSet().get(key);
        }
        isMod = preference == null ? true : preference.isModifiable();
        return isMod;
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        String[] defStr = new String[]{def};
        String[] value = this.getValues(key, defStr);
        return value[0];
    }

    public void setValue(String key, String value) throws UnmodifiableException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (value == null) {
            this.setValues(key, null);
        } else {
            String[] values = new String[]{value};
            this.setValues(key, values);
        }
    }

    public void setValues(String key, String[] values) throws UnmodifiableException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (!this.isModifiable(key)) {
            throw new UnmodifiableException("Preference attribute called " + key + " may not be modified");
        }
        Preference preference = this.portletEntity.getPreferenceSet().get(key);
        if (values == null) {
            if (preference != null) {
                if (!this.preferenceChanges.containsKey(key)) {
                    this.preferenceChanges.put(key, preference == null ? null : preference.getValues());
                }
                PreferenceSetCtrl preferences = (PreferenceSetCtrl)ControllerObjectAccess.get(this.portletEntity.getPreferenceSet());
                preferences.remove(key);
            } else {
                preference = this.portletEntity.getPortletDefinition().getPreferenceSet().get(key);
                if (preference != null) {
                    throw new UnmodifiableException("preference attribute called " + key + " may not be modified");
                }
            }
        } else {
            if (!this.preferenceChanges.containsKey(key)) {
                this.preferenceChanges.put(key, preference == null ? null : preference.getValues());
            }
            ArrayList<String> newValue = new ArrayList<String>(values.length);
            int i = 0;
            while (i < values.length) {
                newValue.add(values[i]);
                ++i;
            }
            if (preference != null) {
                PreferenceCtrl preferenceCtrl = (PreferenceCtrl)ControllerObjectAccess.get(preference);
                preferenceCtrl.setValues(newValue);
            } else {
                PreferenceSetCtrl preferences = (PreferenceSetCtrl)ControllerObjectAccess.get(this.portletEntity.getPreferenceSet());
                preferences.add(key, newValue);
            }
        }
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        Preference preference = this.portletEntity.getPreferenceSet().get(key);
        if (preference == null || preference.getValues() == null || !preference.getValues().hasNext()) {
            preference = this.portletEntity.getPortletDefinition().getPreferenceSet().get(key);
        }
        if (preference == null || preference.getValues() == null || !preference.getValues().hasNext()) {
            return def;
        }
        Vector v = new Vector();
        Iterator values = preference.getValues();
        while (values != null && values.hasNext()) {
            v.add(values.next());
        }
        return v.toArray(new String[v.size()]);
    }

    public Enumeration getNames() {
        return new Enumeration(){
            private Iterator entityIter;
            private Iterator portletIter;
            private String cachedName;
            {
                this.entityIter = PortletPreferencesImpl.this.portletEntity.getPreferenceSet().iterator();
                this.portletIter = PortletPreferencesImpl.this.portletEntity.getPortletDefinition().getPreferenceSet().iterator();
                this.cachedName = null;
            }

            public boolean hasMoreElements() {
                boolean hasNext = false;
                if (this.entityIter.hasNext()) {
                    hasNext = true;
                } else if (this.portletIter.hasNext() && this.cachedName == null) {
                    String name = ((Preference)this.portletIter.next()).getName();
                    if (PortletPreferencesImpl.this.portletEntity.getPreferenceSet().get(name) == null) {
                        hasNext = true;
                        this.cachedName = name;
                    }
                }
                return hasNext;
            }

            public Object nextElement() {
                String name = null;
                if (this.entityIter.hasNext()) {
                    name = ((Preference)this.entityIter.next()).getName();
                } else if (this.cachedName != null) {
                    name = new String(this.cachedName);
                    this.cachedName = null;
                } else {
                    throw new NoSuchElementException();
                }
                return name;
            }
        };
    }

    public void reset(String key) throws UnmodifiableException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (!this.isModifiable(key)) {
            throw new UnmodifiableException("preference attribute called " + key + " may not be modified");
        }
        if (this.preferenceChanges.containsKey(key)) {
            if (this.preferenceChanges.get(key) == null) {
                PreferenceSetCtrl preferences = (PreferenceSetCtrl)ControllerObjectAccess.get(this.portletEntity.getPreferenceSet());
                preferences.remove(key);
            } else {
                Preference preference = this.portletEntity.getPreferenceSet().get(key);
                if (preference != null) {
                    Iterator originalPreferenceValues = (Iterator)this.preferenceChanges.get(key);
                    ArrayList origValues = new ArrayList();
                    while (originalPreferenceValues != null && originalPreferenceValues.hasNext()) {
                        origValues.add(originalPreferenceValues.next());
                    }
                    PreferenceCtrl preferenceCtrl = (PreferenceCtrl)ControllerObjectAccess.get(preference);
                    preferenceCtrl.setValues(origValues);
                } else {
                    Iterator originalPreferenceValues = (Iterator)this.preferenceChanges.get(key);
                    ArrayList origValues = new ArrayList();
                    while (originalPreferenceValues != null && originalPreferenceValues.hasNext()) {
                        origValues.add(originalPreferenceValues.next());
                    }
                    PreferenceSetCtrl preferences = (PreferenceSetCtrl)ControllerObjectAccess.get(this.portletEntity.getPreferenceSet());
                    preferences.add(key, origValues);
                }
            }
            this.preferenceChanges.remove(key);
        }
    }

    public void store() throws IOException, ValidatorException {
        ValidatorDefinition validatorDef = this.portletEntity.getPortletDefinition().getValidatorDefinition();
        if (validatorDef != null) {
            PreferencesValidator validator = validatorDef.getPreferencesValidator();
            validator.validate((PortletPreferences)this);
        }
        PortletEntityCtrl portletEntityCtrl = (PortletEntityCtrl)ControllerObjectAccess.get(this.portletEntity);
        portletEntityCtrl.store();
        this.preferenceChanges.clear();
    }
}

