/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.pluto.core.InternalPortletRequest;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.services.property.PropertyManager;
import org.apache.pluto.util.Enumerator;
import org.apache.pluto.util.NamespaceMapperAccess;

public abstract class PortletRequestImpl
extends HttpServletRequestWrapper
implements PortletRequest,
InternalPortletRequest {
    private PortletWindow portletWindow;
    private PortletSession portletSession = null;
    private PortletPreferences portletPreferences = null;
    private DynamicInformationProvider provider;

    public PortletRequestImpl(PortletWindow portletWindow, HttpServletRequest servletRequest) {
        super(servletRequest);
        this.portletWindow = portletWindow;
        this.provider = InformationProviderAccess.getDynamicProvider(this._getHttpServletRequest());
    }

    private HttpServletRequest _getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    public PortletMode getPortletMode() {
        return this.provider.getPortletMode(this.portletWindow);
    }

    public WindowState getWindowState() {
        return this.provider.getWindowState(this.portletWindow);
    }

    public boolean isWindowStateAllowed(WindowState state) {
        return this.provider.isWindowStateAllowed(state);
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        return this.provider.isPortletModeAllowed(mode);
    }

    public PortletPreferences getPreferences() {
        if (this.portletPreferences == null) {
            this.portletPreferences = PortletObjectAccess.getPortletPreferences(this.portletWindow.getPortletEntity());
        }
        return this.portletPreferences;
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        HttpSession httpSession;
        if (this.portletSession == null && (httpSession = this._getHttpServletRequest().getSession(create)) != null) {
            this.portletSession = PortletObjectAccess.getPortletSession(this.portletWindow, httpSession);
        }
        return this.portletSession;
    }

    public String getResponseContentType() {
        String responseContentType = this.provider.getResponseMimeType();
        return responseContentType;
    }

    public Enumeration getResponseContentTypes() {
        Iterator responseContentTypes = this.provider.getResponseMimeTypes();
        return new Enumerator(responseContentTypes);
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        String prop = this._getHttpServletRequest().getHeader(name);
        if (prop == null) {
            prop = PropertyManager.getProperty(name);
        }
        return prop;
    }

    public Enumeration getProperties(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        Enumeration props = this._getHttpServletRequest().getHeaders(name);
        if (props == null || !props.hasMoreElements()) {
            props = PropertyManager.getProperties(name);
        } else {
            Vector v = new Vector();
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
            props = PropertyManager.getProperties(name);
            while (props != null && props.hasMoreElements()) {
                v.add(props.nextElement());
            }
            props = v.elements();
        }
        return props;
    }

    public Enumeration getPropertyNames() {
        Enumeration props = this._getHttpServletRequest().getHeaderNames();
        if (props == null || !props.hasMoreElements()) {
            props = PropertyManager.getPropertyNames();
        } else {
            Vector v = new Vector();
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
            props = PropertyManager.getPropertyNames();
            while (props != null && props.hasMoreElements()) {
                v.add(props.nextElement());
            }
            props = v.elements();
        }
        return props;
    }

    public PortalContext getPortalContext() {
        return InformationProviderAccess.getPortalContextProvider().getPortalContext();
    }

    public String getAuthType() {
        return this._getHttpServletRequest().getAuthType();
    }

    public String getContextPath() {
        return this._getHttpServletRequest().getContextPath();
    }

    public String getRemoteUser() {
        return this._getHttpServletRequest().getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this._getHttpServletRequest().isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this._getHttpServletRequest().getUserPrincipal();
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        Object attribute = this._getHttpServletRequest().getAttribute(NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(), name));
        if (attribute == null) {
            attribute = this._getHttpServletRequest().getAttribute(name);
        }
        return attribute;
    }

    public Enumeration getAttributeNames() {
        Enumeration attributes = this._getHttpServletRequest().getAttributeNames();
        Vector<String> portletAttributes = new Vector<String>();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            String portletAttribute = NamespaceMapperAccess.getNamespaceMapper().decode(this.portletWindow.getId(), attribute);
            if (portletAttribute == null) continue;
            portletAttributes.add(portletAttribute);
        }
        return portletAttributes.elements();
    }

    public String getCharacterEncoding() {
        return this._getHttpServletRequest().getCharacterEncoding();
    }

    public String getContentType() {
        return this._getHttpServletRequest().getContentType();
    }

    public int getContentLength() {
        return this._getHttpServletRequest().getContentLength();
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        Map parameters = InformationProviderAccess.getDynamicProvider(this._getHttpServletRequest()).getAllParameters(this.portletWindow);
        String[] values = (String[])parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        Map parameters = InformationProviderAccess.getDynamicProvider(this._getHttpServletRequest()).getAllParameters(this.portletWindow);
        return Collections.enumeration(parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        Map parameters = InformationProviderAccess.getDynamicProvider(this._getHttpServletRequest()).getAllParameters(this.portletWindow);
        return (String[])parameters.get(name);
    }

    public Map getParameterMap() {
        return InformationProviderAccess.getDynamicProvider(this._getHttpServletRequest()).getAllParameters(this.portletWindow);
    }

    public Locale getLocale() {
        return this._getHttpServletRequest().getLocale();
    }

    public Enumeration getLocales() {
        return this._getHttpServletRequest().getLocales();
    }

    public boolean isSecure() {
        return this._getHttpServletRequest().isSecure();
    }

    public void setAttribute(String name, Object o) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this._getHttpServletRequest().setAttribute(NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(), name), o);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this._getHttpServletRequest().removeAttribute(NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(), name));
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        return this._getHttpServletRequest().getReader();
    }

    public String getRequestedSessionId() {
        return this._getHttpServletRequest().getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this._getHttpServletRequest().isRequestedSessionIdValid();
    }

    public Cookie[] getCookies() {
        return this._getHttpServletRequest().getCookies();
    }

    public long getDateHeader(String name) {
        return this._getHttpServletRequest().getDateHeader(name);
    }

    public String getHeader(String name) {
        return this._getHttpServletRequest().getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this._getHttpServletRequest().getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this._getHttpServletRequest().getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this._getHttpServletRequest().getIntHeader(name);
    }

    public String getPathInfo() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRequestURI() {
        return null;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return (HttpSession)this.getPortletSession(create);
    }

    public HttpSession getSession() {
        return (HttpSession)this.getPortletSession();
    }

    public String getMethod() {
        return this._getHttpServletRequest().getMethod();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._getHttpServletRequest().isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._getHttpServletRequest().isRequestedSessionIdFromCookie();
    }

    public String getScheme() {
        return this._getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this._getHttpServletRequest().getServerName();
    }

    public int getServerPort() {
        return this._getHttpServletRequest().getServerPort();
    }

    public String getProtocol() {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this._getHttpServletRequest().setCharacterEncoding(env);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this._getHttpServletRequest().getInputStream();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this._getHttpServletRequest().getRequestDispatcher(path);
    }

    public void lateInit(HttpServletRequest webModuleServletRequest) {
        this.setRequest((ServletRequest)webModuleServletRequest);
    }

    public PortletWindow getPortletWindow() {
        return this.portletWindow;
    }
}

