/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.core.impl.PortalContextImpl;
import org.apache.pluto.om.portlet.ContentType;
import org.apache.pluto.om.portlet.ContentTypeSet;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.services.information.PortletURLProvider;

public class PortletURLImpl
implements PortletURL {
    protected PortletWindow portletWindow;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected HashMap parameters = new HashMap();
    protected PortletMode mode = null;
    protected WindowState state = null;
    protected boolean secure;

    private boolean isPortletModeSupported(PortletMode requestedPortletMode, PortletWindow referencedPortletWindow) {
        PortletDefinition portletDefinition = referencedPortletWindow.getPortletEntity().getPortletDefinition();
        ContentTypeSet contentTypes = portletDefinition.getContentTypeSet();
        ContentType contentType = contentTypes.get("text/html");
        Iterator portletModes = contentType.getPortletModes();
        while (portletModes.hasNext()) {
            PortletMode supportedPortletMode = (PortletMode)portletModes.next();
            if (!requestedPortletMode.equals((Object)supportedPortletMode)) continue;
            return true;
        }
        return false;
    }

    public PortletURLImpl(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.portletWindow = portletWindow;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.secure = servletRequest.isSecure();
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.isPortletModeSupported(portletMode, this.portletWindow)) {
            this.mode = portletMode;
            return;
        }
        throw new PortletModeException("unsupported Portlet Mode used: " + portletMode, portletMode);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        PortalContextImpl portalContext = new PortalContextImpl();
        Enumeration supportedWindowStates = portalContext.getSupportedWindowStates();
        while (supportedWindowStates.hasMoreElements()) {
            WindowState supportedWindowState = new WindowState((String)supportedWindowStates.nextElement());
            if (!windowState.equals((Object)supportedWindowState)) continue;
            this.state = windowState;
            return;
        }
        throw new WindowStateException("unsupported Window State used: " + windowState, windowState);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        if (secure) {
            throw new PortletSecurityException("The current implementation does assume not having a supporting security environment installed!");
        }
        this.secure = secure;
    }

    public String toString() {
        StringBuffer url = new StringBuffer(200);
        boolean action = false;
        action = this.getParameter("javax.portlet.action").equalsIgnoreCase("true");
        if (this.parameters.containsKey("javax.portlet.action")) {
            String actionStr = (String)this.parameters.get("javax.portlet.action");
            action = Boolean.valueOf(actionStr);
            this.parameters.remove("javax.portlet.action");
        }
        PortletURLProvider urlProvider = InformationProviderAccess.getDynamicProvider(this.servletRequest).getPortletURL(this.portletWindow);
        if (this.mode != null) {
            urlProvider.setPortletMode(this.mode);
        }
        if (this.state != null) {
            urlProvider.setWindowState(this.state);
        }
        if (action) {
            urlProvider.setAction();
        }
        if (this.secure) {
            urlProvider.setSecure();
        }
        urlProvider.clearParameters();
        urlProvider.setParameters(this.parameters);
        url.append(urlProvider.toString());
        return url.toString();
    }

    public PortletMode getPortletMode() {
        return this.mode;
    }

    public WindowState getWindowState() {
        return this.state;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public String[] getParameters(String name) {
        return (String[])this.parameters.get(name);
    }

    public void setParameters(Map parameters) {
        parameters = new HashMap(parameters);
    }
}

