/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.core.impl.PortletResponseImpl;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.util.NamespaceMapperAccess;

public class RenderResponseImpl
extends PortletResponseImpl
implements RenderResponse {
    private static final String illegalStateExceptionText = "No content type set.";
    private boolean isContentTypeSet = false;

    public RenderResponseImpl(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(portletWindow, servletRequest, servletResponse);
    }

    public PortletURL createActionURL() {
        PortletURL url = this.createURL();
        url.addParameter("javax.portlet.action", "true");
        return url;
    }

    public PortletURL createRenderURL() {
        PortletURL url = this.createURL();
        url.addParameter("javax.portlet.action", "false");
        return url;
    }

    private PortletURL createURL() {
        return PortletObjectAccess.getPortletURL(this.getPortletWindow(), this.getHttpServletRequest(), this._getHttpServletResponse());
    }

    public String encodeNamespace(String aValue) {
        return NamespaceMapperAccess.getNamespaceMapper().encode(this.getPortletWindow().getId(), aValue);
    }

    public void flushBuffer() throws IOException {
        this._getHttpServletResponse().flushBuffer();
    }

    public int getBufferSize() {
        return this._getHttpServletResponse().getBufferSize();
    }

    public String getCharacterEncoding() {
        return this._getHttpServletResponse().getCharacterEncoding();
    }

    public String getContentType() {
        return InformationProviderAccess.getDynamicProvider(this.getHttpServletRequest()).getResponseMimeType();
    }

    public Locale getLocale() {
        return this.getHttpServletRequest().getLocale();
    }

    public OutputStream getPortletOutputStream() throws IOException, IllegalStateException {
        if (!this.isContentTypeSet) {
            throw new IllegalStateException(illegalStateExceptionText);
        }
        return this._getHttpServletResponse().getOutputStream();
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (!this.isContentTypeSet) {
            throw new IllegalStateException(illegalStateExceptionText);
        }
        return this._getHttpServletResponse().getWriter();
    }

    public boolean isCommitted() {
        return this._getHttpServletResponse().isCommitted();
    }

    private boolean isValidContentType(String type) {
        return type.equals("text/html");
    }

    public void reset() {
        this._getHttpServletResponse().reset();
    }

    public void resetBuffer() {
        this._getHttpServletResponse().resetBuffer();
    }

    public void setBufferSize(int size) {
        this._getHttpServletResponse().setBufferSize(size);
    }

    public void setContentType(String type) {
        String mimeType = this.stripCharacterEncoding(type);
        if (!this.isValidContentType(mimeType)) {
            throw new IllegalArgumentException(mimeType);
        }
        this._getHttpServletResponse().setContentType(mimeType);
        this.isContentTypeSet = true;
    }

    public void setTitle(String title) {
    }

    private String stripCharacterEncoding(String type) {
        int xs = type.indexOf(59);
        String strippedType = xs == -1 ? type : type.substring(0, xs);
        return strippedType.trim();
    }

    static {
        illegalStateExceptionText = illegalStateExceptionText;
    }
}

