/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.invoker.impl;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.Constants;
import org.apache.pluto.core.InternalPortletRequest;
import org.apache.pluto.core.InternalPortletResponse;
import org.apache.pluto.invoker.PortletInvoker;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.portlet.PortletUtils;
import org.apache.pluto.services.log.Log;

public class PortletInvokerImpl
implements PortletInvoker {
    private ServletConfig servletConfig;
    private PortletDefinition portletDefinition;

    public PortletInvokerImpl(PortletDefinition portletDefinition, ServletConfig servletConfig) {
        this.portletDefinition = portletDefinition;
        this.servletConfig = servletConfig;
    }

    public void action(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.invoke((PortletRequest)request, (PortletResponse)response, Constants.METHOD_ACTION);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.invoke((PortletRequest)request, (PortletResponse)response, Constants.METHOD_RENDER);
    }

    public void load(PortletRequest request, RenderResponse response) throws PortletException {
        try {
            this.invoke(request, (PortletResponse)response, Constants.METHOD_NOOP);
        }
        catch (IOException e) {
            Log.error("org.apache.pluto.invoker", "PortletInvokerImpl.load() - Error while dispatching portlet.", e);
            throw new PortletException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invoke(PortletRequest portletRequest, PortletResponse portletResponse, Integer methodID) throws PortletException, IOException {
        ServletContext servletContext;
        InternalPortletRequest internalPortletRequest = PortletUtils.getInternalRequest(portletRequest);
        InternalPortletResponse internalPortletResponse = PortletUtils.getInternalResponse(portletResponse);
        ServletRequest servletRequest = ((HttpServletRequestWrapper)internalPortletRequest).getRequest();
        ServletResponse servletResponse = ((HttpServletResponseWrapper)internalPortletResponse).getResponse();
        ServletDefinition servletDefinition = this.portletDefinition.getServletDefinition();
        RequestDispatcher dispatcher = servletDefinition.getRequestDispatcher(servletContext = this.servletConfig.getServletContext());
        if (dispatcher == null) {
            Log.error("org.apache.pluto.invoker", "PortletInvokerImpl.action() - Unable to find RequestDispatcher.");
            return;
        }
        try {
            try {
                servletRequest.setAttribute("org.apache.pluto.core.method", (Object)methodID);
                servletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
                servletRequest.setAttribute("javax.portlet.response", (Object)portletResponse);
                dispatcher.include(servletRequest, servletResponse);
            }
            catch (ServletException e) {
                if (e.getRootCause() != null) {
                    Log.error("org.apache.pluto.invoker", "PortletInvokerImpl.render() - Error while dispatching portlet.", e.getRootCause());
                    if (!(e.getRootCause() instanceof PortletException)) throw new PortletException(e.getRootCause());
                    throw (PortletException)e.getRootCause();
                }
                Log.error("org.apache.pluto.invoker", "PortletInvokerImpl.invoke() - Error while dispatching portlet.", e);
                throw new PortletException((Throwable)e);
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            servletRequest.removeAttribute("org.apache.pluto.core.method");
            servletRequest.removeAttribute("javax.portlet.request");
            servletRequest.removeAttribute("javax.portlet.response");
            throw throwable;
        }
        servletRequest.removeAttribute("org.apache.pluto.core.method");
        servletRequest.removeAttribute("javax.portlet.request");
        servletRequest.removeAttribute("javax.portlet.response");
    }
}

