/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.properties.StringProperty;

public class GenericLiteralCheckerRule
extends AbstractRule {
    private static final String PROPERTY_NAME = "pattern";
    private static final String DESCRIPTION = "Regular Expression";
    private Pattern pattern;

    private void init() {
        if (this.pattern == null) {
            StringProperty property = new StringProperty(PROPERTY_NAME, DESCRIPTION, "", 1.0f);
            String stringPattern = super.getStringProperty(property);
            if (stringPattern != null && stringPattern.length() > 0) {
                this.pattern = Pattern.compile(stringPattern);
            } else {
                throw new IllegalArgumentException("Must provide a value for the 'pattern' property.");
            }
        }
    }

    public Object visit(ASTLiteral node, Object data) {
        this.init();
        String image = node.getImage();
        if (image != null && image.length() > 0 && this.isMatch(image)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean isMatch(String image) {
        Matcher matcher = this.pattern.matcher(image);
        return matcher.find();
    }
}

