/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.ast.TypeNode;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.rules.strings.InefficientStringBuffering;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.typeresolution.TypeHelper;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsecutiveLiteralAppends
extends AbstractRule {
    private static final Set<Class> blockParents = new HashSet<Class>();
    private static final PropertyDescriptor thresholdDescriptor;
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName;
    private int threshold = 1;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTForStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTIfStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTArgumentList;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAdditiveExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLiteral;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTWhileStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTDoStatement;
    private static final /* synthetic */ Class class$java$lang$StringBuffer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchLabel;

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        Node lastBlock;
        if (!ConsecutiveLiteralAppends.isStringBuffer(node)) {
            return data;
        }
        this.threshold = this.getIntProperty(thresholdDescriptor);
        int concurrentCount = this.checkConstructor(node, data);
        Node currentBlock = lastBlock = this.getFirstParentBlock(node);
        Map<VariableNameDeclaration, List<NameOccurrence>> decls = node.getScope().getVariableDeclarations();
        SimpleNode rootNode = null;
        if (concurrentCount == 1) {
            rootNode = node;
        }
        for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : decls.entrySet()) {
            List<NameOccurrence> decl = entry.getValue();
            for (NameOccurrence no : decl) {
                SimpleNode n = no.getLocation();
                currentBlock = this.getFirstParentBlock(n);
                if (!InefficientStringBuffering.isInStringBufferOperation(n, 3, "append")) {
                    if (no.isPartOfQualifiedName()) continue;
                    this.checkForViolation(rootNode, data, concurrentCount);
                    concurrentCount = 0;
                    continue;
                }
                Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
                if (clazz == null) {
                    clazz = new ASTPrimaryExpression[0].getClass().getComponentType();
                }
                ASTPrimaryExpression s = (ASTPrimaryExpression)n.getFirstParentOfType(clazz);
                int numChildren = s.jjtGetNumChildren();
                for (int jx = 0; jx < numChildren; ++jx) {
                    SimpleNode sn = (SimpleNode)s.jjtGetChild(jx);
                    if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                    if (currentBlock != null && lastBlock != null && !currentBlock.equals(lastBlock) || currentBlock == null ^ lastBlock == null) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    }
                    if (concurrentCount == 0) {
                        rootNode = sn;
                    }
                    if (this.isAdditive(sn)) {
                        if ((concurrentCount = this.processAdditive(data, concurrentCount, sn, rootNode)) != 0) {
                            rootNode = sn;
                        }
                    } else if (!this.isAppendingStringLiteral(sn)) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    } else {
                        ++concurrentCount;
                    }
                    lastBlock = currentBlock;
                }
            }
        }
        this.checkForViolation(rootNode, data, concurrentCount);
        return data;
    }

    private int checkConstructor(ASTVariableDeclaratorId node, Object data) {
        Node parent = node.jjtGetParent();
        if (parent.jjtGetNumChildren() >= 2) {
            ASTArgumentList list;
            SimpleNode simpleNode = (SimpleNode)parent.jjtGetChild(1);
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTArgumentList;
            if (clazz == null) {
                clazz = class$net$sourceforge$pmd$ast$ASTArgumentList = new ASTArgumentList[0].getClass().getComponentType();
            }
            if ((list = (ASTArgumentList)simpleNode.getFirstChildOfType(clazz)) != null) {
                Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTLiteral;
                if (clazz2 == null) {
                    clazz2 = class$net$sourceforge$pmd$ast$ASTLiteral = new ASTLiteral[0].getClass().getComponentType();
                }
                ASTLiteral literal = (ASTLiteral)list.getFirstChildOfType(clazz2);
                if (!this.isAdditive(list) && literal != null && literal.isStringLiteral()) {
                    return 1;
                }
                return this.processAdditive(data, 0, list, node);
            }
        }
        return 0;
    }

    private int processAdditive(Object data, int concurrentCount, SimpleNode sn, SimpleNode rootNode) {
        ASTAdditiveExpression additive;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression = new ASTAdditiveExpression[0].getClass().getComponentType();
        }
        if ((additive = (ASTAdditiveExpression)sn.getFirstChildOfType(clazz)) == null) {
            return 0;
        }
        int count = concurrentCount;
        boolean found = false;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            block10: {
                block9: {
                    SimpleNode childNode = (SimpleNode)additive.jjtGetChild(ix);
                    if (childNode.jjtGetNumChildren() != 1) break block9;
                    Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTName;
                    if (clazz2 == null) {
                        clazz2 = new ASTName[0].getClass().getComponentType();
                    }
                    if (childNode.findChildrenOfType(clazz2).size() == 0) break block10;
                }
                if (!found) {
                    this.checkForViolation(rootNode, data, count);
                    found = true;
                }
                count = 0;
                continue;
            }
            ++count;
        }
        if (!found) {
            count = 1;
        }
        return count;
    }

    private boolean isAdditive(SimpleNode n) {
        List lstAdditive;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTAdditiveExpression = new ASTAdditiveExpression[0].getClass().getComponentType();
        }
        if ((lstAdditive = n.findChildrenOfType(clazz)).isEmpty()) {
            return false;
        }
        for (int ix = 0; ix < lstAdditive.size(); ++ix) {
            ASTAdditiveExpression expr = (ASTAdditiveExpression)lstAdditive.get(ix);
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTArgumentList;
            if (clazz2 == null) {
                clazz2 = new ASTArgumentList[0].getClass().getComponentType();
            }
            if (expr.getParentsOfType(clazz2).size() == 1) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !blockParents.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode != null) {
            Class<?> clazz = parentNode.getClass();
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTIfStatement;
            if (clazz2 == null) {
                clazz2 = class$net$sourceforge$pmd$ast$ASTIfStatement = new ASTIfStatement[0].getClass().getComponentType();
            }
            if (clazz.equals(clazz2)) {
                return lastNode;
            }
        }
        if (parentNode == null) return parentNode;
        Class<?> clazz = parentNode.getClass();
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTSwitchStatement;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTSwitchStatement = new ASTSwitchStatement[0].getClass().getComponentType();
        }
        if (!clazz.equals(clazz3)) return parentNode;
        return this.getSwitchParent(parentNode, lastNode);
    }

    private Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            Class<?> clazz = n.getClass();
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTSwitchLabel;
            if (clazz2 == null) {
                clazz2 = new ASTSwitchLabel[0].getClass().getComponentType();
            }
            if (clazz.equals(clazz2)) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    private void checkForViolation(SimpleNode node, Object data, int concurrentCount) {
        if (concurrentCount > this.threshold) {
            Object[] param = new String[]{String.valueOf(concurrentCount)};
            this.addViolation(data, (Node)node, param);
        }
    }

    private boolean isAppendingStringLiteral(SimpleNode node) {
        SimpleNode n = node;
        while (n.jjtGetNumChildren() != 0) {
            Class<?> clazz = n.getClass();
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTLiteral;
            if (clazz2 == null) {
                clazz2 = new ASTLiteral[0].getClass().getComponentType();
            }
            if (clazz.equals(clazz2)) break;
            n = (SimpleNode)n.jjtGetChild(0);
        }
        Class<?> clazz = n.getClass();
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTLiteral;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTLiteral = new ASTLiteral[0].getClass().getComponentType();
        }
        return clazz.equals(clazz3);
    }

    private static boolean isStringBuffer(ASTVariableDeclaratorId node) {
        if (node.getType() != null) {
            Class clazz = node.getType();
            Class<?> clazz2 = class$java$lang$StringBuffer;
            if (clazz2 == null) {
                clazz2 = class$java$lang$StringBuffer = new StringBuffer[0].getClass().getComponentType();
            }
            return clazz.equals(clazz2);
        }
        SimpleNode nn = node.getTypeNameNode();
        if (nn.jjtGetNumChildren() == 0) {
            return false;
        }
        TypeNode typeNode = (TypeNode)((Object)nn.jjtGetChild(0));
        Class<?> clazz = class$java$lang$StringBuffer;
        if (clazz == null) {
            clazz = class$java$lang$StringBuffer = new StringBuffer[0].getClass().getComponentType();
        }
        return TypeHelper.isA(typeNode, (Class)clazz);
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }

    static {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTForStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTForStatement = new ASTForStatement[0].getClass().getComponentType();
        }
        blockParents.add(clazz);
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTWhileStatement;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTWhileStatement = new ASTWhileStatement[0].getClass().getComponentType();
        }
        blockParents.add(clazz2);
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTDoStatement;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTDoStatement = new ASTDoStatement[0].getClass().getComponentType();
        }
        blockParents.add(clazz3);
        Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTIfStatement;
        if (clazz4 == null) {
            clazz4 = class$net$sourceforge$pmd$ast$ASTIfStatement = new ASTIfStatement[0].getClass().getComponentType();
        }
        blockParents.add(clazz4);
        Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTSwitchStatement;
        if (clazz5 == null) {
            clazz5 = class$net$sourceforge$pmd$ast$ASTSwitchStatement = new ASTSwitchStatement[0].getClass().getComponentType();
        }
        blockParents.add(clazz5);
        Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
        if (clazz6 == null) {
            clazz6 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration = new ASTMethodDeclaration[0].getClass().getComponentType();
        }
        blockParents.add(clazz6);
        thresholdDescriptor = new IntegerProperty("threshold", "?", 1, 1.0f);
        propertyDescriptorsByName = ConsecutiveLiteralAppends.asFixedMap(thresholdDescriptor);
    }
}

