/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleChainVisitor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleReference;
import net.sourceforge.pmd.ast.CompilationUnit;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.util.Benchmark;
import net.sourceforge.retroweaver.runtime.java.lang.System_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuleChainVisitor
implements RuleChainVisitor {
    protected List<Rule> rules = new ArrayList<Rule>();
    protected Map<String, List<SimpleNode>> nodeNameToNodes;

    @Override
    public void add(Rule rule) {
        this.rules.add(rule);
    }

    @Override
    public void visitAll(List<CompilationUnit> astCompilationUnits, RuleContext ctx) {
        this.initialize();
        this.clear();
        long start = System_.nanoTime();
        this.indexNodes(astCompilationUnits, ctx);
        long end = System_.nanoTime();
        Benchmark.mark(8, end - start, 1L);
        int visits = 0;
        start = System_.nanoTime();
        for (Rule rule : this.rules) {
            List<String> nodeNames = rule.getRuleChainVisits();
            for (int j = 0; j < nodeNames.size(); ++j) {
                List<SimpleNode> nodes = this.nodeNameToNodes.get(nodeNames.get(j));
                for (SimpleNode node : nodes) {
                    while (rule instanceof RuleReference) {
                        rule = ((RuleReference)rule).getRule();
                    }
                    this.visit(rule, node, ctx);
                }
                visits += nodes.size();
            }
            end = System_.nanoTime();
            Benchmark.mark(1, rule.getName(), end - start, visits);
            start = end;
        }
    }

    protected abstract void visit(Rule var1, SimpleNode var2, RuleContext var3);

    protected abstract void indexNodes(List<CompilationUnit> var1, RuleContext var2);

    protected void indexNode(SimpleNode node) {
        List<SimpleNode> nodes = this.nodeNameToNodes.get(node.toString());
        if (nodes != null) {
            nodes.add(node);
        }
    }

    protected void initialize() {
        if (this.nodeNameToNodes != null) {
            return;
        }
        HashSet<String> visitedNodes = new HashSet<String>();
        Iterator<Rule> i = this.rules.iterator();
        while (i.hasNext()) {
            Rule rule = i.next();
            if (rule.usesRuleChain()) {
                visitedNodes.addAll(rule.getRuleChainVisits());
                continue;
            }
            i.remove();
        }
        this.nodeNameToNodes = new HashMap<String, List<SimpleNode>>();
        for (String s : visitedNodes) {
            ArrayList nodes = new ArrayList(100);
            this.nodeNameToNodes.put(s, nodes);
        }
    }

    protected void clear() {
        for (List<SimpleNode> l : this.nodeNameToNodes.values()) {
            l.clear();
        }
    }
}

