/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import java.util.List;
import net.sourceforge.pmd.ast.ASTLabeledStatement;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.LinkerException;
import net.sourceforge.pmd.dfa.SequenceChecker;
import net.sourceforge.pmd.dfa.SequenceException;
import net.sourceforge.pmd.dfa.StackObject;

public class Linker {
    private List braceStack;
    private List continueBreakReturnStack;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLabeledStatement;

    public Linker(List braceStack, List continueBreakReturnStack) {
        this.braceStack = braceStack;
        this.continueBreakReturnStack = continueBreakReturnStack;
    }

    public void computePaths() throws LinkerException, SequenceException {
        SequenceChecker sc = new SequenceChecker(this.braceStack);
        while (!sc.run()) {
            if (sc.getFirstIndex() < 0 || sc.getLastIndex() < 0) {
                throw new SequenceException("computePaths(): return index <  0");
            }
            StackObject firstStackObject = (StackObject)this.braceStack.get(sc.getFirstIndex());
            switch (firstStackObject.getType()) {
                case 1: {
                    int x = sc.getLastIndex() - sc.getFirstIndex();
                    if (x == 2) {
                        this.computeIf(sc.getFirstIndex(), sc.getFirstIndex() + 1, sc.getLastIndex());
                        break;
                    }
                    if (x == 1) {
                        this.computeIf(sc.getFirstIndex(), sc.getLastIndex());
                        break;
                    }
                    System.out.println("Error - computePaths 1");
                    break;
                }
                case 10: {
                    this.computeWhile(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
                case 20: {
                    this.computeSwitch(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    this.computeFor(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
                case 40: {
                    this.computeDo(sc.getFirstIndex(), sc.getLastIndex());
                    break;
                }
            }
            for (int y = sc.getLastIndex(); y >= sc.getFirstIndex(); --y) {
                this.braceStack.remove(y);
            }
        }
        while (!this.continueBreakReturnStack.isEmpty()) {
            StackObject stackObject = (StackObject)this.continueBreakReturnStack.get(0);
            IDataFlowNode node = stackObject.getDataFlowNode();
            switch (stackObject.getType()) {
                case 50: 
                case 70: {
                    node.removePathToChild(node.getChildren().get(0));
                    IDataFlowNode lastNode = node.getFlow().get(node.getFlow().size() - 1);
                    node.addPathToChild(lastNode);
                    this.continueBreakReturnStack.remove(0);
                    break;
                }
                case 51: {
                    IDataFlowNode last = this.getNodeToBreakStatement(node);
                    node.removePathToChild(node.getChildren().get(0));
                    node.addPathToChild(last);
                    this.continueBreakReturnStack.remove(0);
                    break;
                }
                case 52: {
                    this.continueBreakReturnStack.remove(0);
                }
            }
        }
    }

    private IDataFlowNode getNodeToBreakStatement(IDataFlowNode node) {
        int index;
        List<? extends IDataFlowNode> bList = node.getFlow();
        int findEnds = 1;
        for (index = bList.indexOf(node); index < bList.size() - 2; ++index) {
            SimpleNode parentNode;
            IDataFlowNode n = bList.get(index);
            if (n.isType(41) || n.isType(30) || n.isType(10) || n.isType(20)) {
                ++findEnds;
            }
            if (n.isType(11) || n.isType(23) || n.isType(34) || n.isType(41)) {
                if (findEnds <= 1) break;
                --findEnds;
            }
            if (!n.isType(61)) continue;
            SimpleNode simpleNode = n.getSimpleNode();
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTLabeledStatement;
            if (clazz == null) {
                clazz = new ASTLabeledStatement[0].getClass().getComponentType();
            }
            if ((parentNode = (SimpleNode)simpleNode.getFirstParentOfType(clazz)) == null) break;
            String label = node.getSimpleNode().getImage();
            if (label != null && !label.equals(parentNode.getImage())) continue;
            node.removePathToChild(node.getChildren().get(0));
            IDataFlowNode last = bList.get(index + 1);
            node.addPathToChild(last);
            break;
        }
        return node.getFlow().get(index + 1);
    }

    private void computeDo(int first, int last) {
        IDataFlowNode doSt = ((StackObject)this.braceStack.get(first)).getDataFlowNode();
        IDataFlowNode doExpr = ((StackObject)this.braceStack.get(last)).getDataFlowNode();
        IDataFlowNode doFirst = doSt.getFlow().get(doSt.getIndex() + 1);
        if (doFirst.getIndex() != doExpr.getIndex()) {
            doExpr.addPathToChild(doFirst);
        }
    }

    private void computeFor(int firstIndex, int lastIndex) {
        IDataFlowNode fExpr = null;
        IDataFlowNode fUpdate = null;
        IDataFlowNode fSt = null;
        IDataFlowNode fEnd = null;
        boolean isUpdate = false;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            StackObject so = (StackObject)this.braceStack.get(i);
            IDataFlowNode node = so.getDataFlowNode();
            if (so.getType() == 31) {
                fExpr = node;
                continue;
            }
            if (so.getType() == 32) {
                fUpdate = node;
                isUpdate = true;
                continue;
            }
            if (so.getType() == 33) {
                fSt = node;
                continue;
            }
            if (so.getType() != 34) continue;
            fEnd = node;
        }
        IDataFlowNode end = fEnd.getFlow().get(fEnd.getIndex() + 1);
        IDataFlowNode firstSt = fSt.getChildren().get(0);
        if (isUpdate) {
            if (fSt.getIndex() != fEnd.getIndex()) {
                end.reverseParentPathsTo(fUpdate);
                fExpr.removePathToChild(fUpdate);
                fUpdate.addPathToChild(fExpr);
                fUpdate.removePathToChild(firstSt);
                fExpr.addPathToChild(firstSt);
                fExpr.addPathToChild(end);
            } else {
                fSt.removePathToChild(end);
                fExpr.removePathToChild(fUpdate);
                fUpdate.addPathToChild(fExpr);
                fExpr.addPathToChild(fUpdate);
                fExpr.addPathToChild(end);
            }
        } else if (fSt.getIndex() != fEnd.getIndex()) {
            end.reverseParentPathsTo(fExpr);
            fExpr.addPathToChild(end);
        }
    }

    private void computeSwitch(int firstIndex, int lastIndex) {
        int diff = lastIndex - firstIndex;
        boolean defaultStatement = false;
        IDataFlowNode sStart = ((StackObject)this.braceStack.get(firstIndex)).getDataFlowNode();
        IDataFlowNode sEnd = ((StackObject)this.braceStack.get(lastIndex)).getDataFlowNode();
        IDataFlowNode end = sEnd.getChildren().get(0);
        for (int i = 0; i < diff - 2; ++i) {
            StackObject so = (StackObject)this.braceStack.get(firstIndex + 2 + i);
            IDataFlowNode node = so.getDataFlowNode();
            sStart.addPathToChild(node.getChildren().get(0));
            if (so.getType() != 22) continue;
            defaultStatement = true;
        }
        if (!defaultStatement) {
            sStart.addPathToChild(end);
        }
    }

    private void computeWhile(int first, int last) {
        IDataFlowNode wStart = ((StackObject)this.braceStack.get(first)).getDataFlowNode();
        IDataFlowNode wEnd = ((StackObject)this.braceStack.get(last)).getDataFlowNode();
        IDataFlowNode end = wEnd.getFlow().get(wEnd.getIndex() + 1);
        if (wStart.getIndex() != wEnd.getIndex()) {
            end.reverseParentPathsTo(wStart);
            wStart.addPathToChild(end);
        }
    }

    private void computeIf(int first, int second, int last) {
        IDataFlowNode ifStart = ((StackObject)this.braceStack.get(first)).getDataFlowNode();
        IDataFlowNode ifEnd = ((StackObject)this.braceStack.get(second)).getDataFlowNode();
        IDataFlowNode elseEnd = ((StackObject)this.braceStack.get(last)).getDataFlowNode();
        IDataFlowNode elseStart = ifEnd.getFlow().get(ifEnd.getIndex() + 1);
        IDataFlowNode end = elseEnd.getFlow().get(elseEnd.getIndex() + 1);
        if (ifStart.getIndex() != ifEnd.getIndex() && ifEnd.getIndex() != elseEnd.getIndex()) {
            elseStart.reverseParentPathsTo(end);
            ifStart.addPathToChild(elseStart);
        } else if (ifStart.getIndex() == ifEnd.getIndex() && ifEnd.getIndex() != elseEnd.getIndex()) {
            ifStart.addPathToChild(end);
        } else if (ifEnd.getIndex() == elseEnd.getIndex() && ifStart.getIndex() != ifEnd.getIndex()) {
            ifStart.addPathToChild(end);
        }
    }

    private void computeIf(int first, int last) {
        IDataFlowNode ifStart = ((StackObject)this.braceStack.get(first)).getDataFlowNode();
        IDataFlowNode ifEnd = ((StackObject)this.braceStack.get(last)).getDataFlowNode();
        if (ifStart.getIndex() != ifEnd.getIndex()) {
            IDataFlowNode end = ifEnd.getFlow().get(ifEnd.getIndex() + 1);
            ifStart.addPathToChild(end);
        }
    }
}

