/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.AbstractJavaRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.rules.regex.RegexHelper;
import net.sourceforge.retroweaver.runtime.java.lang.Class_;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericClassCounterRule
extends AbstractJavaRule {
    private static final PropertyDescriptor nameMatchDescriptor = new StringProperty("nameMatch", "A series of regex, separeted by ',' to match on the classname", new String[]{""}, 1.0f, ',');
    private static final PropertyDescriptor operandDescriptor = new StringProperty("operand", "or/and value to refined match criteria", new String(), 2.0f);
    private static final PropertyDescriptor typeMatchDescriptor = new StringProperty("typeMatch", "A series of regex, separeted by ',' to match on implements/extends classname", new String[]{""}, 3.0f, ',');
    private static final PropertyDescriptor thresholdDescriptor = new StringProperty("threshold", "Defines how many occurences are legal", new String(), 4.0f);
    private List<Pattern> namesMatch = new ArrayList<Pattern>(0);
    private List<Pattern> typesMatch = new ArrayList<Pattern>(0);
    private List<SimpleNode> matches = new ArrayList<SimpleNode>(0);
    private List<String> simpleClassname = new ArrayList<String>(0);
    private String operand;
    private int threshold;
    private static String COUNTER_LABEL;

    private List<String> arrayAsList(String[] array) {
        ArrayList<String> list = new ArrayList<String>(array.length);
        int nbItem = 0;
        while (nbItem < array.length) {
            list.add(array[nbItem++]);
        }
        return list;
    }

    protected void init() {
        COUNTER_LABEL = new StringBuffer().append(Class_.getSimpleName(this.getClass())).append(".number of match").toString();
        this.namesMatch = RegexHelper.compilePatternsFromList(this.arrayAsList(this.getStringProperties(nameMatchDescriptor)));
        this.operand = this.getStringProperty(operandDescriptor);
        this.typesMatch = RegexHelper.compilePatternsFromList(this.arrayAsList(this.getStringProperties(typeMatchDescriptor)));
        String thresholdAsString = this.getStringProperty(thresholdDescriptor);
        this.threshold = Integer.valueOf(thresholdAsString);
        this.matches = new ArrayList<SimpleNode>();
    }

    @Override
    public void start(RuleContext ctx) {
        ctx.setAttribute(COUNTER_LABEL, new AtomicLong());
        super.start(ctx);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        for (Pattern pattern : this.typesMatch) {
            if (!RegexHelper.isMatch(pattern, node.getImportedName())) continue;
            if (this.simpleClassname == null) {
                this.simpleClassname = new ArrayList<String>(1);
            }
            this.simpleClassname.add(node.getImportedName());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceType classType, Object data) {
        for (String matchType : this.simpleClassname) {
            if (!this.searchForAMatch(matchType, classType)) continue;
            this.addAMatch(classType, data);
        }
        for (Pattern pattern : this.namesMatch) {
            if (!RegexHelper.isMatch(pattern, classType.getImage())) continue;
            this.addAMatch(classType, data);
        }
        return super.visit(classType, data);
    }

    private void addAMatch(SimpleNode node, Object data) {
        RuleContext ctx = (RuleContext)data;
        AtomicLong total = (AtomicLong)ctx.getAttribute(COUNTER_LABEL);
        total.incrementAndGet();
        this.matches.add(node);
    }

    private boolean searchForAMatch(String matchType, SimpleNode node) {
        boolean status = false;
        String xpathQuery = new StringBuffer().append("//ClassOrInterfaceDeclaration[(./ExtendsList/ClassOrInterfaceType[@Image = '").append(matchType).append("'])").append("or").append("(./ImplementsList/ClassOrInterfaceType[@Image = '").append(matchType).append("'])").append("]").toString();
        try {
            List list = node.findChildNodesWithXPath(xpathQuery);
            if (list != null && list.size() > 0) {
                status = true;
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return status;
    }

    @Override
    public void end(RuleContext ctx) {
        AtomicLong total = (AtomicLong)ctx.getAttribute(COUNTER_LABEL);
        if (total.get() > (long)this.threshold) {
            for (SimpleNode node : this.matches) {
                this.addViolation((Object)ctx, (Node)node, new Object[]{total});
            }
        }
        ctx.removeAttribute(COUNTER_LABEL);
        super.start(ctx);
    }
}

