/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.OnTheFlyRenderer;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLRenderer
extends OnTheFlyRenderer {
    private final String linkPrefix;
    private final String linePrefix;
    private int violationCount = 1;
    boolean colorize = true;

    public HTMLRenderer(String linkPrefix, String linePrefix) {
        this.linkPrefix = linkPrefix;
        this.linePrefix = linePrefix;
    }

    public HTMLRenderer() {
        this(null, null);
    }

    public void renderBody(Writer writer, Report report) throws IOException {
        writer.write("<center><h3>PMD report</h3></center>");
        writer.write("<center><h3>Problems found</h3></center>");
        writer.write(new StringBuffer().append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>").append(PMD.EOL).append("<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>").append(PMD.EOL).toString());
        this.setWriter(writer);
        this.renderFileReport(report);
        writer.write("</table>");
        this.glomProcessingErrors(writer, this.errors);
        if (this.showSuppressedViolations) {
            this.glomSuppressions(writer, this.suppressed);
        }
    }

    @Override
    public void start() throws IOException {
        Writer writer = this.getWriter();
        writer.write(new StringBuffer().append("<html><head><title>PMD</title></head><body>").append(PMD.EOL).toString());
        writer.write("<center><h3>PMD report</h3></center>");
        writer.write("<center><h3>Problems found</h3></center>");
        writer.write(new StringBuffer().append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>").append(PMD.EOL).append("<th>#</th><th>File</th><th>Line</th><th>Problem</th></tr>").append(PMD.EOL).toString());
    }

    @Override
    public void renderFileViolations(Iterator<IRuleViolation> violations) throws IOException {
        Writer writer = this.getWriter();
        this.glomIRuleViolations(writer, violations);
    }

    @Override
    public void end() throws IOException {
        Writer writer = this.getWriter();
        writer.write("</table>");
        this.glomProcessingErrors(writer, this.errors);
        if (this.showSuppressedViolations) {
            this.glomSuppressions(writer, this.suppressed);
        }
        writer.write("</body></html>");
    }

    private void glomIRuleViolations(Writer writer, Iterator<IRuleViolation> violations) throws IOException {
        StringBuffer buf = new StringBuffer(500);
        while (violations.hasNext()) {
            IRuleViolation rv = violations.next();
            buf.setLength(0);
            buf.append("<tr");
            if (this.colorize) {
                buf.append(" bgcolor=\"lightgrey\"");
            }
            this.colorize = !this.colorize;
            buf.append(new StringBuffer().append("> ").append(PMD.EOL).toString());
            buf.append(new StringBuffer().append("<td align=\"center\">").append(this.violationCount).append("</td>").append(PMD.EOL).toString());
            buf.append(new StringBuffer().append("<td width=\"*%\">").append(this.maybeWrap(rv.getFilename(), this.linePrefix == null ? "" : new StringBuffer().append(this.linePrefix).append(Integer.toString(rv.getBeginLine())).toString())).append("</td>").append(PMD.EOL).toString());
            buf.append(new StringBuffer().append("<td align=\"center\" width=\"5%\">").append(Integer.toString(rv.getBeginLine())).append("</td>").append(PMD.EOL).toString());
            String d = StringUtil.htmlEncode(rv.getDescription());
            if (rv.getRule().getExternalInfoUrl() != null && rv.getRule().getExternalInfoUrl().length() != 0) {
                d = new StringBuffer().append("<a href=\"").append(rv.getRule().getExternalInfoUrl()).append("\">").append(d).append("</a>").toString();
            }
            buf.append(new StringBuffer().append("<td width=\"*\">").append(d).append("</td>").append(PMD.EOL).toString());
            buf.append(new StringBuffer().append("</tr>").append(PMD.EOL).toString());
            writer.write(buf.toString());
            ++this.violationCount;
        }
    }

    private void glomProcessingErrors(Writer writer, List<Report.ProcessingError> errors) throws IOException {
        if (!errors.isEmpty()) {
            writer.write("<hr/>");
            writer.write("<center><h3>Processing errors</h3></center>");
            writer.write(new StringBuffer().append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>").append(PMD.EOL).append("<th>File</th><th>Problem</th></tr>").append(PMD.EOL).toString());
            StringBuffer buf = new StringBuffer(500);
            boolean colorize = true;
            for (Report.ProcessingError pe : errors) {
                buf.setLength(0);
                buf.append("<tr");
                if (colorize) {
                    buf.append(" bgcolor=\"lightgrey\"");
                }
                colorize = !colorize;
                buf.append(new StringBuffer().append("> ").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("<td>").append(pe.getFile()).append("</td>").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("<td>").append(pe.getMsg()).append("</td>").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("</tr>").append(PMD.EOL).toString());
                writer.write(buf.toString());
            }
            writer.write("</table>");
        }
    }

    private void glomSuppressions(Writer writer, List<Report.SuppressedViolation> suppressed) throws IOException {
        if (!suppressed.isEmpty()) {
            writer.write("<hr/>");
            writer.write("<center><h3>Suppressed warnings</h3></center>");
            writer.write(new StringBuffer().append("<table align=\"center\" cellspacing=\"0\" cellpadding=\"3\"><tr>").append(PMD.EOL).append("<th>File</th><th>Line</th><th>Rule</th><th>NOPMD or Annotation</th><th>Reason</th></tr>").append(PMD.EOL).toString());
            StringBuffer buf = new StringBuffer(500);
            boolean colorize = true;
            for (Report.SuppressedViolation sv : suppressed) {
                buf.setLength(0);
                buf.append("<tr");
                if (colorize) {
                    buf.append(" bgcolor=\"lightgrey\"");
                }
                colorize = !colorize;
                buf.append(new StringBuffer().append("> ").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("<td align=\"left\">").append(sv.getRuleViolation().getFilename()).append("</td>").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("<td align=\"center\">").append(sv.getRuleViolation().getBeginLine()).append("</td>").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("<td align=\"center\">").append(sv.getRuleViolation().getRule().getName()).append("</td>").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("<td align=\"center\">").append(sv.suppressedByNOPMD() ? "NOPMD" : "Annotation").append("</td>").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("<td align=\"center\">").append(sv.getUserMessage() == null ? "" : sv.getUserMessage()).append("</td>").append(PMD.EOL).toString());
                buf.append(new StringBuffer().append("</tr>").append(PMD.EOL).toString());
                writer.write(buf.toString());
            }
            writer.write("</table>");
        }
    }

    private String maybeWrap(String filename, String line) {
        if (this.linkPrefix == null) {
            return filename;
        }
        String newFileName = filename.substring(0, filename.lastIndexOf(46)).replace('\\', '/');
        return new StringBuffer().append("<a href=\"").append(this.linkPrefix).append(newFileName).append(".html#").append(line).append("\">").append(newFileName).append("</a>").toString();
    }
}

