/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.ExternalRuleID;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleReference;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSetFactory {
    private int minPriority = 5;

    public void setMinimumPriority(int minPriority) {
        this.minPriority = minPriority;
    }

    public Iterator<RuleSet> getRegisteredRuleSets() throws RuleSetNotFoundException {
        try {
            Properties props = new Properties();
            props.load(ResourceLoader.loadResourceAsStream("rulesets/rulesets.properties"));
            String rulesetFilenames = props.getProperty("rulesets.filenames");
            return this.createRuleSets(rulesetFilenames).getRuleSetsIterator();
        }
        catch (IOException ioe) {
            throw new RuntimeException(new StringBuffer().append("Couldn't find rulesets.properties; please ensure that the rulesets directory is on the classpath.  Here's the current classpath: ").append(System.getProperty("java.class.path")).toString());
        }
    }

    public RuleSets createRuleSets(String ruleSetFileNames) throws RuleSetNotFoundException {
        return this.createRuleSets(ruleSetFileNames, this.getClass().getClassLoader());
    }

    public RuleSets createRuleSets(String ruleSetFileNames, ClassLoader classLoader) throws RuleSetNotFoundException {
        RuleSets ruleSets = new RuleSets();
        StringTokenizer st = new StringTokenizer(ruleSetFileNames, ",");
        while (st.hasMoreTokens()) {
            RuleSet ruleSet = this.createSingleRuleSet(st.nextToken().trim(), classLoader);
            ruleSets.addRuleSet(ruleSet);
        }
        return ruleSets;
    }

    public RuleSet createRuleSet(String name, ClassLoader classLoader) throws RuleSetNotFoundException {
        RuleSet[] allRuleSets;
        RuleSets ruleSets = this.createRuleSets(name, classLoader);
        RuleSet result = new RuleSet();
        for (RuleSet ruleSet : allRuleSets = ruleSets.getAllRuleSets()) {
            result.addRuleSet(ruleSet);
        }
        return result;
    }

    public RuleSet createSingleRuleSet(String ruleSetFileName) throws RuleSetNotFoundException {
        return this.createSingleRuleSet(ruleSetFileName, this.getClass().getClassLoader());
    }

    private RuleSet createSingleRuleSet(String ruleSetFileName, ClassLoader classLoader) throws RuleSetNotFoundException {
        return this.parseRuleSetNode(ruleSetFileName, this.tryToGetStreamTo(ruleSetFileName, classLoader), classLoader);
    }

    public RuleSet createRuleSet(InputStream inputStream) {
        return this.createRuleSet(inputStream, this.getClass().getClassLoader());
    }

    public RuleSet createRuleSet(InputStream inputStream, ClassLoader classLoader) {
        return this.parseRuleSetNode(null, inputStream, classLoader);
    }

    private InputStream tryToGetStreamTo(String name, ClassLoader classLoader) throws RuleSetNotFoundException {
        InputStream in = ResourceLoader.loadResourceAsStream(name, classLoader);
        if (in == null) {
            throw new RuleSetNotFoundException(new StringBuffer().append("Can't find resource ").append(name).append(".  Make sure the resource is a valid file or URL or is on the CLASSPATH.  Here's the current classpath: ").append(System.getProperty("java.class.path")).toString());
        }
        return in;
    }

    private RuleSet parseRuleSetNode(String fileName, InputStream inputStream, ClassLoader classLoader) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(inputStream);
            Element ruleSetElement = document.getDocumentElement();
            RuleSet ruleSet = new RuleSet();
            ruleSet.setFileName(fileName);
            ruleSet.setName(ruleSetElement.getAttribute("name"));
            ruleSet.setLanguage(Language.getByName(ruleSetElement.getAttribute("language")));
            NodeList nodeList = ruleSetElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                if (node.getNodeName().equals("description")) {
                    ruleSet.setDescription(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if (node.getNodeName().equals("include-pattern")) {
                    ruleSet.addIncludePattern(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if (node.getNodeName().equals("exclude-pattern")) {
                    ruleSet.addExcludePattern(RuleSetFactory.parseTextNode(node));
                    continue;
                }
                if (!node.getNodeName().equals("rule")) continue;
                this.parseRuleNode(ruleSet, node, classLoader);
            }
            return ruleSet;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(cnfe.getMessage()).toString());
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(ie.getMessage()).toString());
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(iae.getMessage()).toString());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(pce.getMessage()).toString());
        }
        catch (RuleSetNotFoundException rsnfe) {
            rsnfe.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(rsnfe.getMessage()).toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(ioe.getMessage()).toString());
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("Couldn't find that class ").append(se.getMessage()).toString());
        }
    }

    private void parseRuleNode(RuleSet ruleSet, Node ruleNode, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, RuleSetNotFoundException {
        Element ruleElement = (Element)ruleNode;
        String ref = ruleElement.getAttribute("ref");
        if (ref.endsWith("xml")) {
            this.parseRuleSetReferenceNode(ruleSet, ruleElement, ref);
        } else if (ref.trim().length() == 0) {
            this.parseSingleRuleNode(ruleSet, ruleNode, classLoader);
        } else {
            this.parseRuleReferenceNode(ruleSet, ruleNode, ref);
        }
    }

    private void parseRuleSetReferenceNode(RuleSet ruleSet, Element ruleElement, String ref) throws RuleSetNotFoundException {
        RuleSetReference ruleSetReference = new RuleSetReference();
        ruleSetReference.setAllRules(true);
        ruleSetReference.setRuleSetFileName(ref);
        NodeList excludeNodes = ruleElement.getChildNodes();
        for (int i = 0; i < excludeNodes.getLength(); ++i) {
            if (excludeNodes.item(i).getNodeType() != 1 || !excludeNodes.item(i).getNodeName().equals("exclude")) continue;
            Element excludeElement = (Element)excludeNodes.item(i);
            ruleSetReference.addExclude(excludeElement.getAttribute("name"));
        }
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        RuleSet otherRuleSet = ruleSetFactory.createRuleSet(ResourceLoader.loadResourceAsStream(ref));
        for (Rule rule : otherRuleSet.getRules()) {
            if (ruleSetReference.getExcludes().contains(rule.getName()) || rule.getPriority() > this.minPriority) continue;
            RuleReference ruleReference = new RuleReference();
            ruleReference.setRuleSetReference(ruleSetReference);
            ruleReference.setRule(rule);
            ruleSet.addRule(ruleReference);
        }
    }

    private void parseSingleRuleNode(RuleSet ruleSet, Node ruleNode, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Element ruleElement = (Element)ruleNode;
        String attribute = ruleElement.getAttribute("class");
        Class<?> c = classLoader.loadClass(attribute);
        Rule rule = (Rule)c.newInstance();
        rule.setName(ruleElement.getAttribute("name"));
        String since = ruleElement.getAttribute("since");
        if (since.length() > 0) {
            rule.setSince(since);
        }
        rule.setMessage(ruleElement.getAttribute("message"));
        rule.setRuleSetName(ruleSet.getName());
        rule.setExternalInfoUrl(ruleElement.getAttribute("externalInfoUrl"));
        if (ruleElement.hasAttribute("dfa") && ruleElement.getAttribute("dfa").equals("true")) {
            rule.setUsesDFA();
        }
        if (ruleElement.hasAttribute("typeResolution") && ruleElement.getAttribute("typeResolution").equals("true")) {
            rule.setUsesTypeResolution();
        }
        for (int i = 0; i < ruleElement.getChildNodes().getLength(); ++i) {
            Node node = ruleElement.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("description")) {
                rule.setDescription(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals("example")) {
                rule.addExample(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals("priority")) {
                rule.setPriority(Integer.parseInt(RuleSetFactory.parseTextNode(node).trim()));
                continue;
            }
            if (!node.getNodeName().equals("properties")) continue;
            Properties p = new Properties();
            RuleSetFactory.parsePropertiesNode(p, node);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                rule.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rule.getPriority() <= this.minPriority) {
            ruleSet.addRule(rule);
        }
    }

    private void parseRuleReferenceNode(RuleSet ruleSet, Node ruleNode, String ref) throws RuleSetNotFoundException {
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        ExternalRuleID externalRuleID = new ExternalRuleID(ref);
        RuleSet externalRuleSet = ruleSetFactory.createRuleSet(ResourceLoader.loadResourceAsStream(externalRuleID.getFilename()));
        Rule externalRule = externalRuleSet.getRuleByName(externalRuleID.getRuleName());
        if (externalRule == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Unable to find rule ").append(externalRuleID.getRuleName()).append("; perhaps the rule name is mispelled?").toString());
        }
        RuleSetReference ruleSetReference = new RuleSetReference();
        ruleSetReference.setAllRules(false);
        ruleSetReference.setRuleSetFileName(externalRuleID.getFilename());
        RuleReference ruleReference = new RuleReference();
        ruleReference.setRuleSetReference(ruleSetReference);
        ruleReference.setRule(externalRule);
        Element ruleElement = (Element)ruleNode;
        if (ruleElement.hasAttribute("name")) {
            ruleReference.setName(ruleElement.getAttribute("name"));
        }
        if (ruleElement.hasAttribute("message")) {
            ruleReference.setMessage(ruleElement.getAttribute("message"));
        }
        if (ruleElement.hasAttribute("externalInfoUrl")) {
            ruleReference.setExternalInfoUrl(ruleElement.getAttribute("externalInfoUrl"));
        }
        for (int i = 0; i < ruleElement.getChildNodes().getLength(); ++i) {
            Node node = ruleElement.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("description")) {
                ruleReference.setDescription(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals("example")) {
                ruleReference.addExample(RuleSetFactory.parseTextNode(node));
                continue;
            }
            if (node.getNodeName().equals("priority")) {
                ruleReference.setPriority(Integer.parseInt(RuleSetFactory.parseTextNode(node)));
                continue;
            }
            if (!node.getNodeName().equals("properties")) continue;
            Properties p = new Properties();
            RuleSetFactory.parsePropertiesNode(p, node);
            ruleReference.addProperties(p);
        }
        if (externalRule.getPriority() <= this.minPriority) {
            ruleSet.addRule(ruleReference);
        }
    }

    private static void parsePropertiesNode(Properties p, Node propertiesNode) {
        for (int i = 0; i < propertiesNode.getChildNodes().getLength(); ++i) {
            Node node = propertiesNode.getChildNodes().item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("property")) continue;
            RuleSetFactory.parsePropertyNode(p, node);
        }
    }

    private static void parsePropertyNode(Properties p, Node propertyNode) {
        Element propertyElement = (Element)propertyNode;
        String name = propertyElement.getAttribute("name");
        String value = propertyElement.getAttribute("value");
        if (value.trim().length() == 0) {
            for (int i = 0; i < propertyNode.getChildNodes().getLength(); ++i) {
                Node node = propertyNode.getChildNodes().item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("value")) continue;
                value = RuleSetFactory.parseTextNode(node);
            }
        }
        if (propertyElement.hasAttribute("pluginname")) {
            p.setProperty("pluginname", propertyElement.getAttributeNode("pluginname").getNodeValue());
        }
        p.setProperty(name, value);
    }

    private static String parseTextNode(Node node) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() != 4 && childNode.getNodeType() != 3) continue;
            buffer.append(childNode.getNodeValue());
        }
        return buffer.toString();
    }
}

