/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.sourceforge.pmd.DataSource;
import net.sourceforge.pmd.FileDataSource;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.ScopedLogHandlersManager;
import net.sourceforge.pmd.SimpleRuleSetNameMapper;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.ant.RuleSetWrapper;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.AntLogHandler;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PMDTask
extends Task {
    private Path classpath;
    private Path auxClasspath;
    private List<Formatter> formatters = new ArrayList<Formatter>();
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private int minPriority = 5;
    private boolean shortFilenames;
    private String ruleSetFiles;
    private String encoding = System.getProperty("file.encoding");
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private int maxRuleViolations = 0;
    private String targetJDK = "1.5";
    private String failuresPropertyName;
    private String excludeMarker = "NOPMD";
    private int cpus = Runtime.getRuntime().availableProcessors();
    private final Collection<RuleSetWrapper> nestedRules = new ArrayList<RuleSetWrapper>();

    public void setShortFilenames(boolean value) {
        this.shortFilenames = value;
    }

    public void setTargetJDK(String value) {
        this.targetJDK = value;
    }

    public void setExcludeMarker(String value) {
        this.excludeMarker = value;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setFailOnRuleViolation(boolean fail) {
        this.failOnRuleViolation = fail;
    }

    public void setMaxRuleViolations(int max) {
        if (max >= 0) {
            this.maxRuleViolations = max;
            this.failOnRuleViolation = true;
        }
    }

    public void setRuleSetFiles(String ruleSetFiles) {
        this.ruleSetFiles = ruleSetFiles;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public void setFailuresPropertyName(String failuresPropertyName) {
        this.failuresPropertyName = failuresPropertyName;
    }

    public void setMinimumPriority(int minPriority) {
        this.minPriority = minPriority;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFormatter(Formatter f) {
        this.formatters.add(f);
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createLongClasspath().setRefid(r);
    }

    public void setAuxClasspath(Path auxClasspath) {
        this.auxClasspath = auxClasspath;
    }

    public Path getAuxClasspath() {
        return this.auxClasspath;
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        this.createLongAuxClasspath().setRefid(r);
    }

    private void doTask() {
        SourceType sourceType;
        ClassLoader cl;
        this.ruleSetFiles = new AntTaskNameMapper(this.ruleSetFiles).getRuleSets();
        if (this.classpath == null) {
            this.log("Using the normal ClassLoader", 3);
            cl = ((Object)((Object)this)).getClass().getClassLoader();
        } else {
            this.log("Using the AntClassLoader", 3);
            cl = new AntClassLoader(this.getProject(), this.classpath);
        }
        String extraPath = this.getProject().getBaseDir().toString();
        if (this.auxClasspath != null) {
            this.log("Using auxclasspath: " + this.auxClasspath, 3);
            extraPath = this.auxClasspath.toString() + File.pathSeparator + extraPath;
        }
        try {
            cl = new ClasspathClassLoader(extraPath, cl);
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage());
        }
        final ClassLoader classLoader = cl;
        RuleSetFactory ruleSetFactory = new RuleSetFactory(){

            public RuleSets createRuleSets(String ruleSetFileNames) throws RuleSetNotFoundException {
                return this.createRuleSets(PMDTask.this.ruleSetFiles, classLoader);
            }
        };
        Iterator<Formatter> i$ = this.formatters.iterator();
        while (i$.hasNext()) {
            Formatter formatter = i$.next();
            this.log("Sending a report to " + formatter, 3);
            formatter.start(this.getProject().getBaseDir().toString());
        }
        try {
            ruleSetFactory.setMinimumPriority(this.minPriority);
            RuleSets rules = ruleSetFactory.createRuleSets(this.ruleSetFiles, classLoader);
            this.logRulesUsed(rules);
        }
        catch (RuleSetNotFoundException e) {
            throw new BuildException(e.getMessage());
        }
        if (this.targetJDK.equals("1.3")) {
            this.log("Targeting Java language version 1.3", 3);
            sourceType = SourceType.JAVA_13;
        } else if (this.targetJDK.equals("1.5")) {
            this.log("Targeting Java language version 1.5", 3);
            sourceType = SourceType.JAVA_15;
        } else if (this.targetJDK.equals("1.6")) {
            this.log("Targeting Java language version 1.6", 3);
            sourceType = SourceType.JAVA_16;
        } else if (this.targetJDK.equals("1.7")) {
            this.log("Targeting Java language version 1.7", 3);
            sourceType = SourceType.JAVA_17;
        } else if (this.targetJDK.equals("jsp")) {
            this.log("Targeting JSP", 3);
            sourceType = SourceType.JSP;
        } else {
            this.log("Targeting Java language version 1.4", 3);
            sourceType = SourceType.JAVA_14;
        }
        if (this.excludeMarker != null) {
            this.log("Setting exclude marker to be " + this.excludeMarker, 3);
        }
        RuleContext ctx = new RuleContext();
        Report errorReport = new Report();
        final AtomicInteger reportSize = new AtomicInteger();
        Iterator<FileSet> i$2 = this.filesets.iterator();
        while (i$2.hasNext()) {
            FileSet fs = i$2.next();
            LinkedList<DataSource> files = new LinkedList<DataSource>();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            for (int j = 0; j < srcFiles.length; ++j) {
                File file = new File(ds.getBasedir() + System.getProperty("file.separator") + srcFiles[j]);
                files.add(new FileDataSource(file));
            }
            final String inputPath = ds.getBasedir().getPath();
            AbstractRenderer logRenderer = new AbstractRenderer(){

                public void start() {
                }

                public void startFileAnalysis(DataSource dataSource) {
                    PMDTask.this.log("Processing file " + dataSource.getNiceFileName(false, inputPath), 3);
                }

                public void renderFileReport(Report r) {
                    int size = r.size();
                    if (size > 0) {
                        reportSize.addAndGet(size);
                    }
                }

                public void end() {
                }

                public void render(Writer writer, Report r) {
                }
            };
            LinkedList<Renderer> renderers = new LinkedList<Renderer>();
            renderers.add(logRenderer);
            Iterator<Formatter> i$3 = this.formatters.iterator();
            while (i$3.hasNext()) {
                Formatter formatter = i$3.next();
                renderers.add(formatter.getRenderer());
            }
            try {
                PMD.processFiles(this.cpus, ruleSetFactory, sourceType, files, ctx, renderers, this.ruleSetFiles, this.shortFilenames, inputPath, this.encoding, this.excludeMarker, classLoader);
            }
            catch (RuntimeException pmde) {
                pmde.printStackTrace();
                this.log(pmde.toString(), 3);
                if (pmde.getCause() != null) {
                    StringWriter strWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(strWriter);
                    pmde.getCause().printStackTrace(printWriter);
                    this.log(strWriter.toString(), 3);
                }
                if (pmde.getCause() != null && pmde.getCause().getMessage() != null) {
                    this.log(pmde.getCause().getMessage(), 3);
                }
                if (this.failOnError) {
                    throw new BuildException((Throwable)pmde);
                }
                errorReport.addError(new Report.ProcessingError(pmde.getMessage(), ctx.getSourceCodeFilename()));
            }
        }
        int problemCount = reportSize.get();
        this.log(problemCount + " problems found", 3);
        Iterator<Formatter> i$4 = this.formatters.iterator();
        while (i$4.hasNext()) {
            Formatter formatter = i$4.next();
            formatter.end(errorReport);
        }
        if (this.failuresPropertyName != null && problemCount > 0) {
            this.getProject().setProperty(this.failuresPropertyName, String.valueOf(problemCount));
            this.log("Setting property " + this.failuresPropertyName + " to " + problemCount, 3);
        }
        if (this.failOnRuleViolation && problemCount > this.maxRuleViolations) {
            throw new BuildException("Stopping build since PMD found " + problemCount + " rule violations in the code");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.validate();
        AntLogHandler antLogHandler = new AntLogHandler(this);
        ScopedLogHandlersManager logManager = new ScopedLogHandlersManager(Level.FINEST, antLogHandler);
        try {
            this.doTask();
        }
        finally {
            logManager.close();
        }
    }

    private void logRulesUsed(RuleSets rules) {
        this.log("Using these rulesets: " + this.ruleSetFiles, 3);
        RuleSet[] ruleSets = rules.getAllRuleSets();
        for (int j = 0; j < ruleSets.length; ++j) {
            RuleSet ruleSet = ruleSets[j];
            Iterator<Rule> i$ = ruleSet.getRules().iterator();
            while (i$.hasNext()) {
                Rule rule = i$.next();
                this.log("Using rule " + rule.getName(), 3);
            }
        }
    }

    private void validate() throws BuildException {
        Iterator<Formatter> i$ = this.formatters.iterator();
        while (i$.hasNext()) {
            Formatter f = i$.next();
            if (!f.isNoOutputSupplied()) continue;
            throw new BuildException("toFile or toConsole needs to be specified in Formatter");
        }
        if (this.ruleSetFiles == null) {
            if (this.nestedRules.isEmpty()) {
                throw new BuildException("No rulesets specified");
            }
            this.ruleSetFiles = this.getNestedRuleSetFiles();
        }
        if (!(this.targetJDK.equals("1.3") || this.targetJDK.equals("1.4") || this.targetJDK.equals("1.5") || this.targetJDK.equals("1.6") || this.targetJDK.equals("1.7") || this.targetJDK.equals("jsp"))) {
            throw new BuildException("The targetjdk attribute, if used, must be set to either '1.3', '1.4', '1.5', '1.6', '1.7' or 'jsp'");
        }
    }

    private String getNestedRuleSetFiles() {
        StringBuffer sb = new StringBuffer();
        Iterator<RuleSetWrapper> it = this.nestedRules.iterator();
        while (it.hasNext()) {
            RuleSetWrapper rs = it.next();
            sb.append(rs.getFile());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private Path createLongClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    private Path createLongAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void addRuleset(RuleSetWrapper r) {
        this.nestedRules.add(r);
    }

    private class AntTaskNameMapper
    extends SimpleRuleSetNameMapper {
        public AntTaskNameMapper(String s) {
            super(s);
        }

        protected void check(String name) {
            if (name.indexOf("rulesets") == -1 && this.nameMap.containsKey(name)) {
                this.append((String)this.nameMap.get(name));
            } else {
                this.append(PMDTask.this.getProject().replaceProperties(name));
            }
        }
    }
}

